% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessPnts.R
\name{assessPnts}
\alias{assessPnts}
\title{assessPnts}
\usage{
assessPnts(
  reference,
  predicted,
  multiclass = TRUE,
  mappings = levels(as.factor(reference)),
  decimals = 4
)
}
\arguments{
\item{reference}{Data frame column or vector of reference classes.}

\item{predicted}{Data frame column or vector of predicted classes.}

\item{multiclass}{TRUE or FALSE. If more than two classes are differentiated,
use TRUE. If only two classes are differentiated and there are positive and
background/negative classes, use FALSE. Default is TRUE.}

\item{mappings}{Vector of class names. These must be in the same order
as the factor levels so that they are correctly matched to the correct category.
If no mappings are provided, then the factor levels are used by default. For a
binary classification, it is assumed that the first class is "Background" and
the second class is "Positive".}

\item{decimals}{Number of decimal places to return for assessment metrics. Default is 4.}
}
\value{
List object containing the resulting metrics and ancillary information.
}
\description{
Assess semantic segmentation model using point locations
}
\details{
This function generates a set of summary assessment metrics when provided
reference and predicted classes. Results are returned as a list object. For
multiclass assessment, the class names ($Classes), count of samples per class
in the reference data ($referenceCounts), count of samples per class in the
predictions ($predictionCounts), confusion matrix ($confusionMatrix),
aggregated assessment metrics ($aggMetrics) (OA = overall accuracy, macroF1 = macro-averaged
class aggregated F1-score, macroPA = macro-averaged class aggregated producer's
accuracy or recall, and macroUA = macro-averaged class aggregated user's accuracy or
precision), class-level user's accuracies or precisions ($userAccuracies),
class-level producer's accuracies or recalls ($producerAccuracies), and class-level
F1-scores ($F1Scores). For a binary case, the $Classes, $referenceCounts,
$predictionCounts, and $confusionMatrix objects are also returned; however, the $aggMets
object is replaced with $Mets, which stores the following metrics: overall accuracy, recall,
precision, specificity, negative predictive value (NPV), and F1-score.
For binary cases, the second class is assumed to be the positive case.
}
\examples{
#Multiclass example

#Generate example data as data frame of class predictions
inDF <- data.frame(ref = sample(c("Class A", "Class B", "Class C"), 1000, replace=TRUE),
pred = sample(c("Class A", "Class B", "Class C"), 1000, replace=TRUE))

#Calculate metrics
metsOut <- assessPnts(reference=inDF$ref,
                     predicted=inDF$pred,
                     multiclass=TRUE,
                     mappings = c("Class A", "Class B", "Class C"),
                     decimals=4)

print(metsOut)

#Binary example

#Generate example data as data frame of class predictions
inDF <- data.frame(ref = sample(c("Background", "Positive"), 1000, replace=TRUE),
                  pred = sample(c("Background", "Positive"), 1000, replace=TRUE))

#Calculate metrics
metsOut <- assessPnts(reference=inDF$ref,
                     predicted=inDF$pred,
                     multiclass=FALSE,
                     mappings = c("Background", "Positive"),
                     decimals=4)

print(metsOut)
}
