% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension_get_unrelated_instances.R
\name{get_unrelated_instances}
\alias{get_unrelated_instances}
\alias{get_unrelated_instances.geodimension}
\title{Get unrelated instances}
\usage{
get_unrelated_instances(gd, lower_level_name = NULL, upper_level_name = NULL)

\method{get_unrelated_instances}{geodimension}(gd, lower_level_name = NULL, upper_level_name = NULL)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{lower_level_name}{A string, name of the lower level.}

\item{upper_level_name}{A string, name of the upper lever.}
}
\value{
A \code{tibble}.
}
\description{
Given two levels between which an explicit relationship is defined, it
returns the lower-level instances that are not related to any higher-level
instances.
}
\examples{
region <-
  geolevel(name = "region",
           layer = layer_us_region,
           key = c("geoid"))

division <-
  geolevel(name = "division",
           layer = layer_us_division,
           key = c("geoid"))

gd <-
  geodimension(name = "gd_us",
               level = region) |>
  add_level(division)

gd <- gd |>
  relate_levels(lower_level_name = "division",
                upper_level_name = "region",
                by_geography = TRUE)

ui <- gd |>
  get_unrelated_instances(lower_level_name = "division",
                          upper_level_name = "region")

}
\seealso{
Other level association functions: 
\code{\link{add_level}()},
\code{\link{complete_relation_by_geography}()},
\code{\link{geodimension}()},
\code{\link{relate_levels}()}
}
\concept{level association functions}
