% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCMclass.R
\name{summary.FCMres}
\alias{summary.FCMres}
\title{Summary method for FCMres}
\usage{
\method{summary}{FCMres}(object, data = NULL, weighted = TRUE, dec = 3, silent = TRUE, ...)
}
\arguments{
\item{object}{A FCMres object, typically obtained from functions CMeans, GCMeans, SFCMeans, SGFCMeans}

\item{data}{A dataframe to use for the summary statistics instead of obj$data}

\item{weighted}{A boolean indicating if the summary statistics must use the
membership matrix columns as weights (TRUE) or simply assign each
observation to its most likely cluster and compute the statistics on each
subset (FALSE)}

\item{dec}{An integer indicating the number of digits to keep when rounding
(default is 3)}

\item{silent}{A boolean indicating if the results must be printed or silently returned}

\item{...}{Not used}
}
\value{
A list of length k (the number of group). Each element of the list is
  a dataframe with summary statistics for the variables of data for each
  group
}
\description{
Calculate some descriptive statistics of each group of a
FCMres object
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
summary(result)
}
