% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.select}
\alias{spc.select}
\alias{spc.select,Spectra-method}
\title{Selecting rows of a \code{Spectra} object with the mouse}
\usage{
spc.select(object)

\S4method{spc.select}{Spectra}(object)
}
\arguments{
\item{object}{A \code{Spectra} object}
}
\value{
logical Row indexes, TRUE for selected data rows.
}
\description{
This function allows the selection of \code{Spectra} rows that is drawn 
with spc.plot or spc.lines. Selected lines will be colored red. Pressing
the escape button will end the selection process and return selecion results.
}
\examples{
sp <- spc.example_spectra()
spc.plot(sp)
spc.setselected.idx(sp)<-spc.select(sp)

}
\seealso{
\code{\link{spc.plot}} \code{\link{spc.lines}}
}
