% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/selpos.R
\name{selpos}
\alias{selpos}
\title{Geographical point selection.}
\usage{
selpos(lat, lon = NULL, ind)
}
\arguments{
\item{lat}{Latitude of points or list containing lat,lon.}

\item{lon}{Longitude of data points. If missing, this must be part of the
lat argument.}

\item{ind}{Selection criterion.}
}
\value{
Returns list with elements lat,lon which satisfy the criterion.
}
\description{
Select geographical data points by arbitrary criterion.
}
\details{
The normal way of working with geographical data is to store positions as a
list with names lat and lon. This is easier for most applications, except
selection of subsets, where it is essential to access individual elements.
The purpose of this routine is merely to ease the selection process.
}
\examples{
\dontrun{
             subs<-selpos(pos,,z>6)# Select positions where z>6

       The Function is trivially defined as
       function(lat, lon = NULL, ind)
       {
                      if(is.null(lon)) {
                           lon <- lat$lon
                           lat <- lat$lat
                      }
                      lat <- lat[ind]
                      lon <- lon[ind]
                      return(lat, lon)
       }
}
}
\seealso{
\code{\link{geoplot}},
}

