% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{read_exponential}
\alias{read_exponential}
\title{Parses the integer coefficient in an exponential term.}
\usage{
read_exponential(s, has_index)
}
\arguments{
\item{s}{A string that starts with one of the following forms: \code{exp(x)}, \code{exp(-x)}, \code{exp(2x)}, \code{exp(-2x)}, \code{exp(12*x)}, \code{exp(-123*x)}, followed by other terms. If \code{has_index == TRUE}, the first term should be rewritten in \code{x} with an index (e.g. \code{exp(x1)}, \code{exp(-2*x2)}).}

\item{has_index}{A logical, indicates whether the term is written in a component (e.g. \code{x1}, \code{x2}) as opposed to a uniform term (i.e. \code{x}).}
}
\value{
A list containing the following elements:
   \item{power_numer}{An integer, the integer coefficient inside the first exponential term.}
   \item{idx}{An integer, the index of the term matched (e.g. \code{3} for \code{exp(2*x3)}). \code{NULL} if \code{has_index == FALSE}.}
   \item{s}{A string, the rest of the unparsed string.}
If parsing is unsuccessful, \code{NULL} is returned.
}
\description{
Parses the integer coefficient in an exponential term.
}
\details{
Parses the coefficient in the first exponential term and returns the rest of the terms.
}
\examples{
# Unsuccessful parsing, not starting with exponential, returns \code{NULL}.
read_exponential("x", FALSE)
# Unsuccessful parsing, not starting with exponential, returns \code{NULL}.
read_exponential("x1^2+exp(2x2)", TRUE)
read_exponential("exp(x)", FALSE)
read_exponential("exp(x1)", TRUE)
read_exponential("exp(-x)", FALSE)
read_exponential("exp(-x1)+x2^2", TRUE)
read_exponential("exp(2x)", FALSE)
read_exponential("exp(2x1)+x2^(-2/3)", TRUE)
read_exponential("exp(-2x)", FALSE)
read_exponential("exp(-2x1)+exp(x3)", TRUE)
read_exponential("exp(12x)", FALSE)
read_exponential("exp(12x2)+x3^(-3)+x4^2", TRUE)
read_exponential("exp(-12x)", FALSE)
read_exponential("exp(-12x3)+x1^(2/5)+log(x2)", TRUE)
read_exponential("exp(123*x)", FALSE)
read_exponential("exp(123*x1)+x2^4", TRUE)
read_exponential("exp(-123*x)", FALSE)
read_exponential("exp(-123*x4)+exp(2*x3)", TRUE)
}
