% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_genlogis_as.R
\name{distrib_as}
\alias{distrib_as}
\alias{pgenlog_as}
\alias{dgenlog_as}
\alias{qgenlog_as}
\alias{rgenlog_as}
\title{The Generalized logistic distribution with skewness}
\usage{
pgenlog_as(q, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0, skew = .5)

dgenlog_as(x, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0, skew = 0.5)

qgenlog_as(k, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0, skew = 0.5)

rgenlog_as(n, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0, skew = 0.5)
}
\arguments{
\item{a, b, p}{parameters >= 0, with restrictions.*}

\item{mu}{mu parameter}

\item{skew}{skewness parameter limited to the interval (-1, 1)}

\item{x, q}{vector of quantiles.}

\item{k}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required}
}
\value{
\code{dgenlog_as} gives the density, \code{pgenlog_as} gives the distribution function, 
\code{qgenlog_as} gives the quantile function, and \code{rgenlog_as} generates random deviates.\cr
 
 The length of the result is determined by \code{n} for \code{rgenlog_as}, and is the maximum of the lengths 
 of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function and random generation a generalized logistic distribution with skewness.
}
\details{
The used distribution for this package is given by: \deqn{f(x) = 2*((a + b*(1+p)*(abs(x-mu)^p))*exp(-(x-mu)*(a+b*(abs(x-mu)^p))))/ 
   ((exp(-(x-mu)*(a + b* (abs(x-mu)^p)))+1)^2) *
   ((exp(-(skew*(x-mu))*(a+b*(abs(skew*(x-mu))^p)))+1)^(-1)) }
   
The \code{qgenlog_as()} returns values for P(X < x).\cr 

The default values for \code{a, b, p and mu} produces a function with mean 0 and variance close to 1.\cr 

*Restrictions:\cr 

If \code{p} equals to 0, \code{b} or \code{a} must be 0 otherwise there is identifiability problem.\cr 

The distribution is not defined for \code{a} and \code{b} equal to 0 simultaneously.\cr
}
\examples{
pgenlog_as(0.5) 
curve(dgenlog_as(x), xlim = c(-3,3)) 

rgenlog_as(100) 

qgenlog_as(0.95)

}
\references{
Rathie, P. N. and Swamee, P. K (2006) \emph{On a new invertible generalized logistic distribution
approximation to normal distribution}, Technical Research Report in Statistics, 07/2006,
Dept. of Statistics, Univ. of Brasilia, Brasilia, Brazil.

Azzalini, A. (1985) \emph{A class of distributions which includes the normal ones}. Scandinavian Journal of Statistics.
}
\keyword{genlogis}
