% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{Hardy-Weinberg}
\alias{Hardy-Weinberg}
\alias{test_HW}
\alias{HWtable_analysis}
\title{Tests of Hardy-Weinberg genotypic proportions}
\usage{
test_HW(inputFile, which = "Proba", outputFile = "", settingsFile = "",
  enumeration = FALSE, dememorization = 10000, batches = 20,
  iterations = 5000, verbose = interactive())

HWtable_analysis(inputFile, which = "Proba", settingsFile = "",
  enumeration = FALSE, dememorization = 10000, batches = 20,
  iterations = 5000, verbose = interactive())
}
\arguments{
\item{inputFile}{character: The path of the input file, in Genepop format}

\item{which}{character: \code{'Proba'}, \code{'excess'}, and \code{'deficit'} to perform the probability test, score test for excess, and score tests for deficit, respectively, in each population and for each locus. \code{test_HW} additionally handles \code{'global excess'} and  \code{'global deficit'} for global tests for all loci and/or all populations, and \code{HWtable_analysis} additionally handles \code{'Fis'} to report basic information (allele frequencies and Fis).}

\item{outputFile}{character: The path of the output file}

\item{settingsFile}{character: The path of the settings file}

\item{enumeration}{logical: whether to compute the complete enumeration test for samples with less than 5 alleles}

\item{dememorization}{integer: length of dememorization step of Markov chain algorithm}

\item{batches}{integer: Number of batches}

\item{iterations}{integer: Iterations per batch}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Compute variants of the exact conditional test for Hardy-Weinberg genotypic proportions.  The tests differ by their test statistics. \code{HWtable_analysis} handles a single table of genotype counts, and \code{test_HW} requires a standard genepop input file. See \href{../doc/all-menu-options.html#option-1-hardy-weinberg-hw-exact-tests}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
infile <- system.file('extdata', 'sample.txt',package='genepop')
locinfile <- 'sample.txt' ## file in user's directory not in R's extdata directory
check <- file.copy(infile,locinfile,overwrite=TRUE)
test_HW(locinfile, which='deficit', 'sample.txt.D')
# Example in Guo & Thompson 1992 Table 5
infile <- system.file('extdata', 'Rhesus.txt',package='genepop')
locinfile <- 'Rhesus.txt'
check <- file.copy(infile,locinfile,overwrite=TRUE)
outfile <- HWtable_analysis(locinfile,which='Proba',batches = 1000,iterations = 1000)
readLines(outfile)[21]
}
