% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPubmed.R
\name{getPubmed}
\alias{getPubmed}
\title{Get pubmed paper records by searching abstract}
\usage{
getPubmed(term, keys)
}
\arguments{
\item{term}{query terms e.g. gene id, GO/KEGG term or id}

\item{keys}{other searching keys}
}
\value{
A list of `tibble` for pubmed records
}
\description{
Get pubmed paper records by searching abstract
}
\examples{
\donttest{
term <- c("Tp53","Brca1","Tet2")
keys <- c('stem cell','mouse')
l <- getPubmed(term,keys)
# very easy to output
expoSheet(l,name_list = term, filename = 'test.xlsx',dir = tempdir())
}

}
