% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_hapVisualization.R
\name{hap_summary}
\alias{hap_summary}
\title{Summary Hap Results}
\usage{
hap_summary(hap,
            hapPrefix = "H",
            file = file)
}
\arguments{
\item{hap}{object of hapResult class, generated by \code{vcf2hap()}
or \code{seqs2hap} or \code{import_hap()}}

\item{hapPrefix}{prefix of hap names, default as "H"}

\item{file}{file path where to save the hap summary result.
If missing, nothing will be saved to disk.}
}
\value{
hapSummary, first four rows are fixed to meta information: CHR, POS, INFO, ALLELE
Hap names were placed in first column, Accessions and freqs were placed at the last two columns.
}
\description{
A function used for summarize hapResult to visualization and calculation.
}
\details{
It is suggested to use the result of \code{vcf2hap()} or \code{seqs2hap()}
as input directly.
However the user can import previously hap result from local file
with \code{import_hap()}
}
\note{
If the user have changed the default \code{hapPrefix} in \code{vcf2hap()} or \code{seqs2hap()},
then the parameter \code{hapPrefix} is needed.
Furthermore, a multi-letter prefix of hap names is possible.
}
\examples{
data("geneHapR_test")
hapSummary <- hap_summary(hapResult, hapPrefix = "H")
}
