/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.util;

import java.util.ArrayList;
import java.util.List;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;

public class WindowResults
implements MCMCResults {
    private final MCMCResults d_nested;
    private final int d_start;
    private final int d_end;
    private List<MCMCResultsListener> d_listeners = new ArrayList<MCMCResultsListener>();

    public WindowResults(MCMCResults nested, int start, int end) {
        this.d_nested = nested;
        this.d_start = start;
        this.d_end = end;
    }

    public void addResultsListener(MCMCResultsListener l) {
        this.d_listeners.add(l);
    }

    public int findParameter(Parameter p) {
        return this.d_nested.findParameter(p);
    }

    public int getNumberOfChains() {
        return this.d_nested.getNumberOfChains();
    }

    public int getNumberOfSamples() {
        return this.d_end - this.d_start;
    }

    public Parameter[] getParameters() {
        return this.d_nested.getParameters();
    }

    public double getSample(int p, int c, int i) {
        if (i >= this.getNumberOfSamples()) {
            throw new IndexOutOfBoundsException("Index " + i + " out of bounds: " + this.getNumberOfSamples());
        }
        return this.d_nested.getSample(p, c, i + this.d_start);
    }

    public void removeResultsListener(MCMCResultsListener l) {
        this.d_listeners.remove(l);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }
}

