% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpgee.R
\name{predict.qpgee}
\alias{predict.qpgee}
\title{Predict method for qpgee model objects}
\usage{
\method{predict}{qpgee}(object, ...)
}
\arguments{
\item{object}{A "qpgee" model object.}

\item{...}{Additional arguments to the function. Can include `newdata`, a dataframe
containing the new data to predict on. The structure of `newdata` should match that of the data
the model was originally fitted with, specifically in terms of the variables it contains.
Additional arguments are ignored.}
}
\value{
If `newdata` is not supplied, returns a vector of predictions based on the fitted values
   and handling of NAs specified in the model object. If `newdata` is supplied, returns a vector
   of predictions for the new data.
}
\description{
This function makes predictions from a "qpgee" model object. When `newdata` is not provided,
it returns predictions using the original data the model was fitted on. If `newdata` is supplied
(through `...`), it uses this new data for prediction.
}
\examples{
# Example usage:
sim_data <- generateData(nsub = 100, nobs = rep(10, 100),  p = 100,
                         beta0 = c(rep(1,7),rep(0,93)), rho = 0.6, correlation = "AR1",
                          dis = "normal", ka = 1)

X=sim_data$X
y=sim_data$y

#fit qpgee
qpgee.fit = qpgee(X,y,tau=0.5,nobs=rep(10, 100),lambda = 0.1)
predict(qpgee.fit)

}
