% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/current_price.R
\name{current_price}
\alias{current_price}
\title{Current coin prices}
\usage{
current_price(
  coin_ids,
  vs_currencies = c("usd"),
  include_market_cap = TRUE,
  include_24h_vol = TRUE,
  include_24h_change = TRUE,
  max_attempts = 3
)
}
\arguments{
\item{coin_ids}{(character): a vector with IDs of the coins of
interest. An up-to-date list of supported coins and their
IDs can be obtained with the \code{\link[=supported_coins]{supported_coins()}} function.}

\item{vs_currencies}{(character): a vector with
names of the reference currencies to express the price in, e.g.
\code{c("usd", "eur", "btc")}. An up-to-date list of supported
\code{vs_currencies} (both fiat and cryptocurrencies) can be obtained with
the \code{\link[=supported_currencies]{supported_currencies()}} function. If \code{vs_currencies}
contains at least one unsupported currency, the call will fail with the
respective error message.}

\item{include_market_cap}{(boolean, defaults to
\code{TRUE}): whether to return the market capitalisation information.}

\item{include_24h_vol}{(boolean, defaults to \code{TRUE}):
whether to return the trading volume for the last 24 hours.}

\item{include_24h_change}{(boolean, defaults to
\code{TRUE}): whether to return the price percentage change compared to 24
hours ago.}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble, which by the default will contain the following columns (use
arguments \code{include_market_cap}, \code{include_24h_vol} and \code{include_24h_change}
to control the inclusion of the corresponding columns):
\itemize{
\item \code{coin_id} (character): coin IDs, ordered alphabetically;
\item \code{vs_currency} (character): reference currency, in which the price of
\code{coin_id} is expressed;
\item \code{last_updated_at} (POSIXct, UTC time zone): timestamp of the last price
update;
\item \code{market_cap} (double): current market capitalisation;
\item \code{vol_24h} (double): trading volume in the last 24 hours;
\item \code{price_percent_change_24h} (double): percentage change of the price as
compared to 24 hours ago.
}
}
\description{
Retrieves current prices of supported coins in any supported reference currencies
}
\details{
This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.

If no data can be retrieved (e.g. because of a misspecified
query parameter), nothing (\code{NULL}) will be returned.
}
\examples{
\donttest{
r <- current_price(
  coin_ids = c("aave", "tron", "bitcoin"),
  vs_currencies = c("usd", "eur", "gbp")
)
print(r)
}
}
