% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_fn.R
\name{spectre.citations}
\alias{spectre.citations}
\title{Get in text citations for SPECTRE layers}
\usage{
spectre.citations(index)
}
\arguments{
\item{index}{numeric. A vector of integers specifying the layers. Refer to the Details section.}
}
\value{
list. Contains two elements, both characters: the first a single 
character containing the in-text citations, the second a character of 
length \code{x} with the bibliographic citations.
}
\description{
Generate in-text citations for a selection of SPECTRE layers.
}
\details{
The current layers in SPECTRE are:
\enumerate{
 \item \strong{MINING_AREA}. Mining density based on the number of known mining properties (pre-operational, operational, and closed) in a 50-cell radius (1x1 km cells).
 \item \strong{HAZARD_POTENTIAL}. Number of significant hazards (earthquakes, volcanoes, landslides, floods, drought, cyclones) potentially affecting cells based on hazard frequency data.
 \item \strong{HUMAN_DENSITY} Continuous metric of population density.
 \item \strong{BUILT_AREA} Percentage metric indicating the built-up presence.
 \item \strong{ROAD_DENSITY}. Continuous metric of road density.
 \item \strong{FOOTPRINT_PERC}. Percentage metric indicating anthropogenic impacts on the environment.
 \item \strong{IMPACT_AREA}. Classification of land into very low impact areas (1), low impact areas (2) and non-low impact areas (3).
 \item \strong{MODIF_AREA}. Continuous 0-1 metric that reflects the proportion of a landscape that has been modified.
 \item \strong{HUMAN_BIOMES}. Classification of land cover into different anthropogenic biomes of differing pressure such as dense settlements, villages and cropland.
 \item \strong{FIRE_OCCUR}. Continuous metric of mean fire occurrence during the years of 2006 and 2016.
 \item \strong{CROP_PERC_UNI}. Percentage metric indicating the proportion of cropland in each cell.
 \item \strong{CROP_PERC_IIASA}. Percentage metric indicating the proportion of cropland in each cell.
 \item \strong{LIVESTOCK_MASS}. Estimated total amount of livestock wet biomass based on global livestock head counts.
 \item \strong{FOREST_LOSS_PERC}. Continuous -100 to 100 metric of forest tree cover loss between 2007 and 2017.
 \item \strong{FOREST_TREND}. Classification metric of 0 (no loss) or a discrete value from 1 to 17, representing loss (a stand-replacement disturbance or change from a forest to non-forest state) detected primarily in the year 2001-2019, respectively.
 \item \strong{NPPCARBON_GRAM}. Quantity of carbon needed to derive food and fiber products (HANPP).
 \item \strong{NPPCARBON_PERC}. HANNP as a percentage of local Net Primary Productivity.
 \item \strong{LIGHT_MCDM2}. Continuous simulated zenith radiance data.
 \item \strong{FERTILIZER_LGHA}. Continuous metric of kilograms of fertilizer used per hectare.
 \item \strong{TEMP_TRENDS}. Continuous metric of temperature trends, based on the linear regression coefficients of mean monthly temperature for the years of 1950 to 2019.
 \item \strong{TEMP_SIGNIF}. Continuous metric of temperature trend significance, the temperature trends divided by its standard error.
 \item \strong{CLIM_EXTREME}. Continuous metric calculated as whatever is the largest of the absolute of the trend coefficients of the months with the lowest or highest mean temperatures.
 \item \strong{CLIM_VELOCITY}. Continuous metric of the velocity of climate change, the ratio between TEMP_TRENDS and a local spatial gradient in mean temperature calculated as the slope of a plane fitted to the values of a 3x3 cell neighbourhood centered on each pixel.
 \item \strong{ARIDITY_TREND}. Continuous metric of aridity trends, based on the linear regression coefficients of aridity for the years of 1990 to 2019, i.e: MPET/(MPRE+1).
}
}
\examples{
sources = c(2,3)
out = spectre.citations(sources)
}
