% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle2d.R
\name{angle2d}
\alias{angle2d}
\title{Determine angle}
\usage{
angle2d(coords1, coords2, radians = FALSE)
}
\arguments{
\item{coords1}{An \eqn{N \times 2} matrix of spatial coordinates.}

\item{coords2}{An \eqn{N \times 2} matrix of spatial coordinates.}

\item{radians}{A logical indicating whether degrees or radians should be returned.  Default is FALSE, meaning return angle in degrees.}
}
\value{
Returns a vector of angles.
}
\description{
\code{angle2d} determines the angle between pairs of coordinates in degrees or radians.  The coordinats are assumed to be in 2d space.
}
\details{
Note that the angle is between the actual pairs of points, not the angle between the vectors extending from the origin to the points.  e.g., the angle between cbind(0, 1) and cbind(1, 1) would be 90 degrees, not 45.  Sign of the direction not accounted for, e.g., a -135 degree angle is rotated by 180 degrees to become a 45 degree angle.  All angles returned are in the interval [0, 180].
}
\examples{
coords1 = matrix(0, nrow = 8, ncol = 2)
coords2 = cbind(c(2, 2, 0, -2, -2, -2, 0, 2), c(0, 2, 2, 2, 0, -2, -2, -2))
angle2d(coords1, coords2)
angle2d(coords1, coords2, radians = TRUE)
}
\author{
Joshua French
}

