% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgd.R
\name{rgd}
\alias{rgd}
\title{robust geographical detector(RGD) model}
\usage{
rgd(formula, data, discvar = NULL, discnum = 3:8, minsize = 1, cores = 1)
}
\arguments{
\item{formula}{A formula of RGD model.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{discvar}{Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent
variables are used as \code{discvar}.}

\item{discnum}{A numeric vector of discretized classes of columns that need to be discretized.
Default all \code{discvar} use \code{3:8}.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}
}
\value{
A list.
\describe{
\item{\code{factor}}{the result of RGD model}
\item{\code{disc}}{robust discrete results}
}
}
\description{
Function for robust geographical detector(RGD) model.
}
\note{
Please set up python dependence and configure \code{GDVERSE_PYTHON} environment variable if you want to run \code{rgd()}.
See \code{vignette('rgdrid',package = 'gdverse')} for more details.
}
\examples{
\dontrun{
## The following code needs to configure the Python environment to run:
data('sim')
g = rgd(y ~ .,
        data = dplyr::select(sim,-dplyr::any_of(c('lo','la'))),
        discnum = 3:6, cores = 6)
g
}
}
\references{
Zhang, Z., Song, Y.*, & Wu, P., 2022. Robust geographical detector. International Journal of Applied Earth Observation and Geoinformation. 109, 102782.
DOI: 10.1016/j.jag.2022.102782.
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
