% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{register_gfont}
\alias{register_gfont}
\title{Register a 'Google Fonts'}
\usage{
register_gfont(family = "Open Sans", subset = c("latin", "latin-ext"))
}
\arguments{
\item{family}{family name of a 'Google Fonts', for example, "Open Sans", "Roboto",
"Fira Code" or "Fira Sans Condensed". Complete list is available with the
following command:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gfonts::get_all_fonts()$family |>
  unlist() |>
  unique() |>
  sort()
}\if{html}{\out{</div>}}}

\item{subset}{font subset, a character vector, it defaults to only "latin" and
"latin-ext" and can contains values such as "greek", "emoji", "chinese-traditional",

Run the following code to get a complete list:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gfonts::get_all_fonts()$subsets |> unlist() |> unique() |> sort()
}\if{html}{\out{</div>}}}
}
\value{
TRUE if the operation went ok.
}
\description{
Register a font from 'Google Fonts' so that it can be used
with devices using the 'systemfonts' package, i.e. the 'flextable'
package and graphic outputs generated with the 'ragg', 'svglite'
and 'ggiraph' packages.
}
\details{
It allows users to use fonts from 'Google Fonts' in an HTML page generated by 'shiny' or 'R Markdown'.
At the first request, the font files will be downloaded and stored in a cache on the
user's machine, thus avoiding many useless downloads or allowing to work with
these fonts afterwards without an Internet connection, in a docker image for example.
See \code{\link[=fonts_cache_dir]{fonts_cache_dir()}}.

The server delivering the font files should not be too busy. That's
why a one second pause is added after each download to respect the server's
limits. This time can be set with the option \code{GFONTS_DOWNLOAD_SLEEPTIME} which
must be a number of seconds.
}
\examples{
\dontrun{
if (check_gfonts()) {
  dummy_setup()
  register_gfont(family = "Roboto")
}
}
}
\seealso{
Other functions for font management: 
\code{\link{addGFontHtmlDependency}()},
\code{\link{fonts_cache_dir}()},
\code{\link{gfontHtmlDependency}()},
\code{\link{install_gfont_script}()},
\code{\link{installed_gfonts}()},
\code{\link{liberationsansHtmlDependency}()},
\code{\link{register_liberationsans}()}
}
\concept{functions for font management}
