% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_config_option}
\alias{get_config_option}
\title{Get GDAL configuration option}
\usage{
get_config_option(key)
}
\arguments{
\item{key}{Character name of a configuration option.}
}
\value{
Character. The value of a (key, value) option previously set with
\code{set_config_option()}. An empty string (\code{""}) is returned if \code{key} is not
found.
}
\description{
\code{get_config_option()} gets the value of GDAL runtime configuration option.
Configuration options are essentially global variables the user can set.
They are used to alter the default behavior of certain raster format
drivers, and in some cases the GDAL core. For a full description and
listing of available options see
\url{https://gdal.org/user/configoptions.html}.
}
\examples{
## this option is set during initialization of the gdalraster package
get_config_option("OGR_CT_FORCE_TRADITIONAL_GIS_ORDER")
}
\seealso{
\code{\link[=set_config_option]{set_config_option()}}

\code{vignette("gdal-config-quick-ref")}
}
