% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcharts_us_areas.R
\name{gchart_generate_us_areas}
\alias{gchart_generate_us_areas}
\title{Generate Google Charts spatial data for US areas}
\usage{
gchart_generate_us_areas(areas = 1:1000L, limit = 1000)
}
\arguments{
\item{areas}{Area codes to get. Should be integers.}

\item{limit}{Maximum number of areas to look for.}
}
\value{
Returns a simple features `data.frame` with class `sf`, representing
the spatial data for all areas with a valid id between 1 and a 1000 from the
Google Charts servers, using the WGS84 (epsg = 4326) coordinate reference
system.
You need to first run `gchart_set_cache()` so the package knows where to
store the downloaded data.
}
\description{
This function queries 'Google Charts' resources to identify the US geographic
areas used in services like Google Trends, and uses geographic data from the
US Census Bureau to provide those areas with subdivisions at the county level.
}
\examples{

library(package = "gchartsmap")

# set the cache path to your system's cache path
gchartsmap::gchart_set_cache(path = tempdir())

# GET and process area 500
gchartsmap::gchart_generate_us_areas(500L)

# clean up
list.files(
  tempdir(), all.files = TRUE, full.names = TRUE, recursive = TRUE
)

}
