% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl_gaussian_2D.R
\name{rgl_gaussian_2D}
\alias{rgl_gaussian_2D}
\title{Produce a 3D plot of the 2D Gaussian via rgl}
\usage{
rgl_gaussian_2D(
  gauss_data,
  normalize = TRUE,
  viridis_dir = 1,
  viridis_opt = "B",
  x_lab = "X values",
  y_lab = "Y values",
  box = FALSE,
  aspect = TRUE,
  ...
)
}
\arguments{
\item{gauss_data}{Data.frame with X_values, Y_values, and predicted_values,
e.g. exported from \code{predict_gaussian_2D()}}

\item{normalize}{Default TRUE, should predicted_values be normalized on a 0
to 1 scale?}

\item{viridis_dir}{See "direction" in scale_fill_viridis_c()}

\item{viridis_opt}{See "option" in scale_fill_viridis_c()}

\item{x_lab}{Arguments passed to xlab()}

\item{y_lab}{Arguments passed to ylab()}

\item{box}{Whether to draw a box; see \code{rgl::plot3d()}}

\item{aspect}{Whether to adjust the aspect ratio; see \code{rgl::plot3d()}}

\item{...}{Other arguments supplied to \code{rgl::plot3d()}}
}
\value{
An rgl object (i.e. of the class 'rglHighlevel'). See
\code{rgl::plot3d()} for details.
}
\description{
Produce a 3D plot of the 2D Gaussian via rgl
}
\examples{
if (interactive()) {
  ## Load the sample data set
  data(gaussplot_sample_data)

  ## The raw data we'd like to use are in columns 1:3
  samp_dat <-
    gaussplot_sample_data[,1:3]


  #### Example 1: Unconstrained elliptical ####
  ## This fits an unconstrained elliptical by default
  gauss_fit <-
    fit_gaussian_2D(samp_dat)

  ## Generate a grid of x- and y- values on which to predict
  grid <-
    expand.grid(X_values = seq(from = -5, to = 0, by = 0.1),
                Y_values = seq(from = -1, to = 4, by = 0.1))

  ## Predict the values using predict_gaussian_2D
  gauss_data <-
    predict_gaussian_2D(
      fit_object = gauss_fit,
      X_values = grid$X_values,
      Y_values = grid$Y_values,
    )

  ## Plot via ggplot2 and metR
  library(ggplot2); library(metR)
  ggplot_gaussian_2D(gauss_data)

  ## Produce a 3D plot via rgl
  rgl_gaussian_2D(gauss_data)


  #### Example 2: Constrained elliptical_log ####
  ## This fits a constrained elliptical, as in Priebe et al. 2003
  gauss_fit <-
    fit_gaussian_2D(
      samp_dat,
      method = "elliptical_log",
      constrain_orientation = -1
    )

  ## Generate a grid of x- and y- values on which to predict
  grid <-
    expand.grid(X_values = seq(from = -5, to = 0, by = 0.1),
                Y_values = seq(from = -1, to = 4, by = 0.1))

  ## Predict the values using predict_gaussian_2D
  gauss_data <-
    predict_gaussian_2D(
      fit_object = gauss_fit,
      X_values = grid$X_values,
      Y_values = grid$Y_values,
    )

  ## Plot via ggplot2 and metR
  ggplot_gaussian_2D(gauss_data)

  ## Produce a 3D plot via rgl
  rgl_gaussian_2D(gauss_data)
}
}
\author{
Vikram B. Baliga
}
