% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_gaussian_volume.R
\name{get_volume_gaussian_2D}
\alias{get_volume_gaussian_2D}
\title{Compute volume under 2D gaussian}
\usage{
get_volume_gaussian_2D(X_sig, Y_sig)
}
\arguments{
\item{X_sig}{numeric value of the x-axis spread (sigma)}

\item{Y_sig}{numeric value of the y-axis spread (sigma)}
}
\value{
A numeric value indicating the computed volume
}
\description{
Compute volume under 2D gaussian
}
\details{
Volume under the 2D gaussian is computed as:
\code{2 * pi * sqrt(abs(X_sig)) * sqrt(abs(Y_sig))}
}
\examples{
library(gaussplotR)

get_volume_gaussian_2D(5, 3) #24.33467
}
\author{
Vikram B. Baliga
}
