% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgr1st.R
\name{fgr1st}
\alias{fgr1st}
\title{Calculates a dependence graph using Gaussian stepwise selection}
\usage{
fgr1st(x,p0=0.01,nu=1,kmn=0,kmx=0,nedge=10^5,inr=T,xinr=F)
}
\arguments{
\item{x}{The matrix of covariates}

\item{p0}{Cut-off P-value}

\item{nu}{The order statistic of Gaussian covariates used for comparison.}

\item{kmn,}{The minimum number selected variables for each node irrespective of cut-off P-value}

\item{kmx}{The maximum number selected variables for each node irrespective of cut-off P-value}

\item{nedge}{Maximum number of edges}

\item{inr}{Logical, if TRUE include an intercept}

\item{xinr}{Logical, if TRUE intercept already included}

}
\value{
ned Number of edges

edg List of edges together with P-values for each  edge and proportional reduction of sum of squared residuals.
}
\description{
Calculates an independence graph using Gaussian stepwise selection
}
\examples{
data(boston)
a<-fgr1st(boston[,1:13])
}
