% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobreg.R
\name{frobreg}
\alias{frobreg}
\title{Robust regression using Huber's psi-function}
\usage{
frobreg(y,x,cn=1,sg=0,scale=T,inr=T,xinr=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{Tuning parameter for Huber's psi-function}

\item{sg}{Scale}

\item{scale}{ Logical, if TRUE calculates sg simultaneously, otherwise keeps initial sg}

\item{inr}{Logical if TRUE to include intercept}

\item{xinr}{Logical if TRUE intercept already included}
}
\value{
beta Regression coefficients

res  Residuals

sg  Scale
}
\description{
Robust regression using Huber's psi-function
}
\examples{
data(boston)
a<-frobreg(boston[,14],boston[,1:13])
}
