% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_external_account.R
\name{oauth_external_token}
\alias{oauth_external_token}
\title{Generate OAuth token for an external account.}
\usage{
oauth_external_token(
  path = "",
  scopes = "https://www.googleapis.com/auth/cloud-platform"
)
}
\arguments{
\item{path}{JSON containing the workload identity configuration for the
external account, in one of the forms supported for the \code{txt} argument of
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (probably, a file path, although it could be a JSON
string). The instructions for generating this configuration are given at
\href{https://cloud.google.com/iam/docs/configuring-workload-identity-federation}{Configuring workload identity federation}.

Note that external account tokens are a natural fit for use as Application
Default Credentials, so consider storing the configuration file in one of
the standard locations consulted for ADC, instead of providing \code{path}
explicitly. See \code{\link[=credentials_app_default]{credentials_app_default()}} for more.}

\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email and is generally considered a low-value
scope.}
}
\description{
Generate OAuth token for an external account.
}
\keyword{internal}
