% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_service_account.R
\name{credentials_service_account}
\alias{credentials_service_account}
\title{Load a service account token}
\usage{
credentials_service_account(scopes = NULL, path = "", ..., subject = NULL)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email. It is considered a low value scope and
does not appear on the consent screen.}

\item{path}{JSON identifying the service account, in one of the forms
supported for the \code{txt} argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a
file path or JSON string).}

\item{...}{Additional arguments passed to all credential functions.}

\item{subject}{An optional subject claim. Use for a service account which has
been granted domain-wide authority by an administrator. Such delegation of
domain-wide authority means that the service account is permitted to act on
behalf of users, without their consent. Identify the user to impersonate
via their email, e.g. \code{subject = "user@example.com"}.}
}
\value{
An \code{\link[httr:Token-class]{httr::TokenServiceAccount}} or \code{NULL}.
}
\description{
Load a service account token
}
\examples{
\dontrun{
token <- credentials_service_account(
  scopes = "https://www.googleapis.com/auth/userinfo.email",
  path = "/path/to/your/service-account.json"
)
}
}
\seealso{
Additional reading on delegation of domain-wide authority:
\itemize{
\item \url{https://developers.google.com/identity/protocols/oauth2/service-account#delegatingauthority}
}

Other credential functions: 
\code{\link{credentials_app_default}()},
\code{\link{credentials_byo_oauth2}()},
\code{\link{credentials_gce}()},
\code{\link{credentials_user_oauth2}()},
\code{\link{token_fetch}()}
}
\concept{credential functions}
