% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expr-generics.R, R/Expr-methods.R
\docType{methods}
\name{GaExpr}
\alias{GaExpr}
\alias{GaExpr,character,character-method}
\title{GaExpr.}
\usage{
GaExpr(object, comparator, operand, metricScope = "")

\S4method{GaExpr}{character,character}(object, comparator, operand,
  metricScope = "")
}
\arguments{
\item{object}{A dimension or metric variable, or another object to be coerced
to an .expr object.}

\item{comparator}{The comparator to use for the expression.}

\item{operand}{The operand to use for the expression.}

\item{metricScope}{Optional scope to use for segmentation if using a metric.
Possible values include "perUser" or "perSession".}
}
\description{
Create a Core Reporting API expression.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = character,comparator = character}: Return a Google Analytics expression using the described
variable, operator and operand.
}}

\examples{
myQuery <- GaQuery(view = 123456789)
source_matches_google <- GaExpr("source", "~", "google")
TableFilter(myQuery) <- source_matches_google
}
\seealso{
Other expression generators: \code{\link{Expr}},
  \code{\link{McfExpr}}, \code{\link{RtExpr}}
}
\concept{expression generators}
