% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_select.R
\name{select.data_request}
\alias{select.data_request}
\alias{galah_select}
\title{Keep or drop columns using their names}
\usage{
\method{select}{data_request}(.data, ..., group)

galah_select(..., group)
}
\arguments{
\item{.data}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}.}

\item{...}{Zero or more individual column names to include.}

\item{group}{\code{string}: (optional) name of one or more column groups to
include. Valid options are \code{"basic"}, \code{"event"} \code{"taxonomy"}, \code{"media"} and
\code{"assertions"}.}
}
\value{
A tibble
specifying the name and type of each column to include in the
call to \code{atlas_counts()} or \code{atlas_occurrences()}.
}
\description{
Select (and optionally rename) variables in a data frame, using
a concise mini-language that makes it easy to refer to variables based on
their name. Note that unlike calling \code{select()} on a local tibble, this
implementation is only evaluated at the
\code{\link[=collapse.data_request]{collapse()}} stage, meaning any errors
or messages will be triggered at the end of the pipe.

\code{select()} supports \code{dplyr} \strong{selection helpers}, including:
\itemize{
\item \code{\link[dplyr]{everything}}: Matches all variables.
\item \code{\link[dplyr]{last_col}}: Select last variable, possibly with an
offset.
}

Other helpers select variables by matching patterns in their names:
\itemize{
\item \code{\link[dplyr]{starts_with}}: Starts with a prefix.
\item \code{\link[dplyr]{ends_with}}: Ends with a suffix.
\item \code{\link[dplyr]{contains}}: Contains a literal string.
\item \code{\link[dplyr]{matches}}: Matches a regular expression.
\item \code{\link[dplyr]{num_range}}: Matches a numerical range like x01,
x02, x03.
}

Or from variables stored in a character vector:
\itemize{
\item \code{\link[dplyr]{all_of}}: Matches variable names in a character
vector. All names must be present, otherwise an out-of-bounds error is
thrown.
\item \code{\link[dplyr]{any_of}}: Same as \code{all_of()}, except that no error
is thrown for names that don't exist.
}

Or using a predicate function:
\itemize{
\item \code{\link[dplyr]{where}}: Applies a function to all variables and selects those for which the function returns \code{TRUE}.
}
}
\details{
GBIF nodes store content in hundreds of different fields, and users often
require thousands or millions of records at a time. To reduce time taken to
download data, and limit complexity of the resulting \code{tibble}, it is sensible
to restrict the fields returned by occurrence queries. The full list of
available fields can be viewed with \code{show_all(fields)}. Note that \code{select()}
and \code{galah_select()} are supported for all atlases that allow downloads, with
the exception of GBIF, for which all columns are returned.

Calling the argument \code{group = "basic"} returns the following columns:
\itemize{
\item \code{decimalLatitude}
\item \code{decimalLongitude}
\item \code{eventDate}
\item \code{scientificName}
\item \code{taxonConceptID}
\item \code{recordID}
\item \code{dataResourceName}
\item \code{occurrenceStatus}
}

Using \code{group = "event"} returns the following columns:
\itemize{
\item \code{eventRemarks}
\item \code{eventTime}
\item \code{eventID}
\item \code{eventDate}
\item \code{samplingEffort}
\item \code{samplingProtocol}
}

Using \code{group = "media"} returns the following columns:
\itemize{
\item \code{multimedia}
\item \code{multimediaLicence}
\item \code{images}
\item \code{videos}
\item \code{sounds}
}

Using \code{group = "taxonomy"} returns higher taxonomic information for a given
query. It is the only \code{group} that is accepted by \code{atlas_species()} as well
as \code{atlas_occurrences()}.

Using \code{group = "assertions"} returns all quality assertion-related
columns. The list of assertions is shown by \code{show_all_assertions()}.

For \code{atlas_occurrences()}, arguments passed to \code{...} should be valid field
names, which you can check using \code{show_all(fields)}. For \code{atlas_species()},
it should be one or more of:
\itemize{
\item \code{counts} to include counts of occurrences per species.
\item \code{synonyms} to include any synonymous names.
\item \code{lists} to include authoritative lists that each species is included on.
}
}
\examples{
\dontrun{
# Download occurrence records of *Perameles*, 
# Only return scientificName and eventDate columns
galah_config(email = "your-email@email.com")
galah_call() |>
  identify("perameles")|>
  select(scientificName, eventDate) |>
  collect()

# Only return the "basic" group of columns and the basisOfRecord column
galah_call() |>
  identify("perameles") |>
  select(basisOfRecord, group = "basic") |>
  collect()
  
# When used in a pipe, `galah_select()` and `select()` are synonymous.
# Hence the previous example can be rewritten as:
galah_call() |>
  galah_identify("perameles") |>
  galah_select(basisOfRecord, group = "basic") |>
  collect()
}
}
\seealso{
\code{\link[=filter.data_request]{filter()}},
\code{\link[=st_crop.data_request]{st_crop()}} and
\code{\link[=identify.data_request]{identify()}} for other ways to restrict
the information returned; \code{show_all(fields)} to list available fields.
}
