#' Collect a set of expert distributions
#' 
#' Not exported yet as taxonomic queries are not yet optimized
#' @param request optional `data_request` object: generated by a call to
#' [galah_call()].
#' @param identify `data.frame`: generated by a call to
#' [galah_identify()].
#' @param filter `data.frame`: generated by a call to
#' [galah_filter()]
#' @return An object of classes `sf`, `tbl`, `tbl_df` and `data.frame` 
#' (aka a Simple feature collection) of distribution maps, with one column per
#' map, and spatial data stored in the `geometry` column.
#' @examples
#' 
#' x <- show_all(distributions) |>
#'   slice_head(n = 4)
#' 
#' y <- galah_call() |>
#'   filter(id == x$id) |>
#'   atlas_distributions()
#' ggplot() +
#'   geom_sf(data = ozmap_country) +
#'   geom_sf(data = st_as_sf(x))
#' @noRd
#' @keywords Internal
atlas_distributions <- function(request = NULL, 
                                filter = NULL,
                                identify = NULL){
  args <- as.list(environment()) # capture supplied arguments
  .query <- check_atlas_inputs(args) # convert to `data_request` object
  .query$type <- "distributions"
  collect(.query)
    # NOTE: 
    # taxonomic queries *only* work for lsid's that specifically referenced;
    # i.e. it acts more like `filter()` than `identify()`
    # it could be made to act in a more 'taxonomic' way by calling `atlas_species()` first
}