% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_bbox.R
\name{galah_bbox}
\alias{galah_bbox}
\title{Narrow a query to within a bounding box}
\usage{
galah_bbox(...)
}
\arguments{
\item{...}{an \code{sf} object or a shapefile (.shp), or bounding box coordinates
supplied as a \code{bbox}, a \code{tibble}/\code{data.frame}}
}
\value{
length-1 object of class \code{character} and \code{galah_geolocate},
containing a multipolygon WKT string representing the bounding box of the
area provided.
}
\description{
Restrict results to within a bounding box (a box constructed from min/max
latitude & longitude coordinates).
Bounding boxes can be extracted from a supplied \code{sf}/\code{sfc} object or
a shapefile. A bounding box can also be supplied as a \code{bbox} object
(via \code{sf::st_bbox}) or a \code{tibble}/\code{data.frame}.
}
\details{
an \code{sf} object or a shapefile polygon will be simplified to its
bbox coordinates. A bounding box can be supplied as a \code{bbox} object or as
a \code{tibble}/\code{data.frame}. Bounding boxes supplied as a \code{tibble}/\code{data.frame}
must have "xmin", "xmax", "ymin" and "ymax" columns with valid \code{numeric}
values.
}
\section{Examples}{


Search for records using a bounding box of coordinates

\if{html}{\out{<div class="sourceCode r">}}\preformatted{b_box <- sf::st_bbox(c(xmin = 143, xmax = 148, ymin = -29, ymax = -28), 
                     crs = st_crs("WGS84"))

galah_call() |>
  galah_identify("reptilia") |>
  galah_bbox(b_box) |>
  atlas_counts()
#> Data returned for bounding box:
#> xmin = 143 xmax = 148 ymin = -29 ymax = -28
#> # A tibble: 1 x 1
#>   count
#>   <int>
#> 1  1782
}\if{html}{\out{</div>}}

Search for records using a bounding box in a \code{tibble} or \code{data.frame}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{b_box <- tibble(xmin = 148, ymin = -29, xmax = 143, ymax = -21)

galah_call() |>
  galah_identify("vulpes") |>
  galah_bbox(b_box) |>
  atlas_counts()
#> Data returned for bounding box:
#> xmin = 148 xmax = 143 ymin = -29 ymax = -21
#> # A tibble: 1 x 1
#>   count
#>   <int>
#> 1   225
}\if{html}{\out{</div>}}

Search for records within the bounding box of an \code{sf} object

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_config(email = "your-email@email.com")

location <- 
"POLYGON((143.32 -18.78,145.30 -20.52,141.52 -21.50,143.32 -18.78))" |>
 sf::st_as_sfc()
 
galah_call() |>
  galah_identify("vulpes") |>
  galah_bbox(location) |>
  atlas_occurrences()
}\if{html}{\out{</div>}}

Search for records within the bounding box of a shapefile

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_config(email = "your-email@email.com")

location <- sf::st_read(path/to/shapefile.shp)
galah_call() |>
  galah_identify("vulpes") |>
  galah_bbox(location) |>
  atlas_occurrences()
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=galah_polygon]{galah_polygon()}} & \code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to narrow
queries by location. See \code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_select]{galah_select()}} for other ways to restrict the information
returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
}
\keyword{internal}
