% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ala_media.R
\name{ala_media}
\alias{ala_media}
\title{Image and sounds}
\usage{
ala_media(
  identifier,
  identifier_type = "media",
  download_dir,
  media_type = c("image", "sound")
)
}
\arguments{
\item{identifier}{\code{string}: a single or vector of occurrence or media
identifiers. The type is specified by \code{identifier_type}}

\item{identifier_type}{\code{string}: one of \code{c("occurrence", "media")}.
Defaults to \code{"media"}.}

\item{download_dir}{\code{string}: path to directory to store the downloaded media
in}

\item{media_type}{\code{string}: type of media to download, one or both of
\code{c("image", "sound")}. Defaults to both.}
}
\value{
\code{data.frame} of media information
}
\description{
In addition to text data describing individual occurrences and their attributes,
ALA stores image and sounds associated with a given record. These can be
downloaded to \code{R} by first using \code{\link{ala_occurrences}()} to
find records that contain media, and then passing the resulting \code{recordID}
field to \code{\link{ala_media}()} to download those media files (see examples).
}
\examples{
\dontrun{
# Search for galah records with images
occ <- ala_occurrences(
    taxa = select_taxa("Eolophus Roseicapilla"),
    filters = select_filters(multimedia = "Image", year = 2020))

# get images associated with these records
images <- ala_media(occ$recordID,
    identifier_type = "occurrence",
    download_dir = tempdir(), media_type = "image")
}
}
