% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotope-maneuvers.R
\name{isomap2raster}
\alias{isomap2raster}
\title{convert columns of an ISOMAP isoscape to a raster object}
\usage{
isomap2raster(isoscape, column, Proj = raster::projection(get_wrld_simpl()))
}
\arguments{
\item{isoscape}{the data frame of prediction.txt from ISOMAP.  The latitude column must be named
"lat" and the longitude column must be named "long".}

\item{column}{the name of the column to turn into a raster object.  This should be
a quoted string, like "predkrig".}

\item{Proj}{the desired projection.
By default it is raster::projection(get_wrld_simpl()), i.e. the same projection as the wrld_simpl map.}
}
\description{
Just simple conversion, but nice to have this in a brief function
}
\examples{
isorast <- isomap2raster(isomap_job54152_prediction, "predreg")
isorast
}

