% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ggm_old.R
\name{ggmfit}
\alias{ggmfit}
\alias{ggmfitr}
\title{Iterative proportional fitting of graphical Gaussian model}
\usage{
ggmfit(
  S,
  n.obs,
  glist,
  start = NULL,
  eps = 1e-12,
  iter = 1000,
  details = 0,
  ...
)
}
\arguments{
\item{S}{Empirical covariance matrix}

\item{n.obs}{Number of observations}

\item{glist}{Generating class for model (a list)}

\item{start}{Initial value for concentration matrix}

\item{eps}{Convergence criterion}

\item{iter}{Maximum number of iterations}

\item{details}{Controlling the amount of output.}

\item{...}{Optional arguments; currently not used}
}
\value{
A list with \item{lrt}{Likelihood ratio statistic (-2logL)}
\item{df}{Degrees of freedom} \item{logL}{log likelihood}
\item{K}{Estimated concentration matrix (inverse covariance matrix)}
}
\description{
Fit graphical Gaussian model by iterative proportional fitting.
}
\details{
\code{ggmfit} is based on a C implementation.  \code{ggmfitr} is
implemented purely in R (and is provided mainly as a benchmark for the
C-version).
}
\examples{

## Fitting "butterfly model" to mathmark data
## Notice that the output from the two fitting functions is not
## entirely identical.
data(math)
glist <- list(c("al", "st", "an"), c("me", "ve", "al"))
d <- cov.wt(math, method="ML")
ggmfit (d$cov, d$n.obs, glist)

}
\seealso{
\code{\link{cmod}}, \code{\link{loglin}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{multivariate}
