% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hull.R
\name{convexHull}
\alias{convexHull}
\title{Find the convex hull of a set of points.}
\usage{
convexHull(
  pts,
  addRays = FALSE,
  useRGLBBox = FALSE,
  direction = 1,
  tol = mean(mean(abs(pts))) * sqrt(.Machine$double.eps) * 2
)
}
\arguments{
\item{pts}{A matrix with a point in each row.}

\item{addRays}{Add the ray defined by \code{direction}.}

\item{useRGLBBox}{Use the RGL bounding box when add rays.}

\item{direction}{Ray direction. If i'th entry is positive, consider the i'th column of \code{pts}
plus a value greater than on equal zero (minimize objective $i$). If negative, consider the
i'th column of \code{pts} minus a value greater than on equal zero (maximize objective $i$).}

\item{tol}{Tolerance on std. dev. if using PCA.}
}
\value{
A list with \code{hull} equal a matrix with row indices of the vertices defining each
facet in the hull and \code{pts} equal the input points (and dummy points) and columns:
\code{pt}, true if a point in the original input; false if a dummy point (a point on a ray).
\code{vtx}, TRUE if a vertex in the hull.
}
\description{
Find the convex hull of a set of points.
}
\examples{
## 1D
pts<-matrix(c(1,2,3), ncol = 1, byrow = TRUE)
dimFace(pts) # a line
convexHull(pts)
convexHull(pts, addRays = TRUE)

## 2D
pts<-matrix(c(1,1, 2,2), ncol = 2, byrow = TRUE)
dimFace(pts) # a line
convexHull(pts)
plotHull2D(pts, drawPoints = TRUE)
convexHull(pts, addRays = TRUE)
plotHull2D(pts, addRays = TRUE, drawPoints = TRUE)
pts<-matrix(c(1,1, 2,2, 0,1), ncol = 2, byrow = TRUE)
dimFace(pts) # a polygon
convexHull(pts)
plotHull2D(pts, drawPoints = TRUE)
convexHull(pts, addRays = TRUE, direction = c(-1,1))
plotHull2D(pts, addRays = TRUE, direction = c(-1,1), addText = "coord")

## 3D
pts<-matrix(c(1,1,1), ncol = 3, byrow = TRUE)
dimFace(pts) # a point
convexHull(pts)
pts<-matrix(c(0,0,0,1,1,1,2,2,2,3,3,3), ncol = 3, byrow = TRUE)
dimFace(pts) # a line
convexHull(pts)
pts<-matrix(c(0,0,0,0,1,1,0,2,2,0,0,2), ncol = 3, byrow = TRUE)
dimFace(pts) # a polygon
convexHull(pts)
convexHull(pts, addRays = TRUE)
pts<-matrix(c(1,0,0,1,1,1,1,2,2,3,1,1), ncol = 3, byrow = TRUE)
dimFace(pts) # a polygon
convexHull(pts) # a polyhedron
pts<-matrix(c(1,1,1,2,2,1,2,1,1,1,1,2), ncol = 3, byrow = TRUE)
dimFace(pts) # a polytope (polyhedron)
convexHull(pts)

ini3D(argsPlot3d = list(xlim = c(0,3), ylim = c(0,3), zlim = c(0,3)))
pts<-matrix(c(1,1,1,2,2,1,2,1,1,1,1,2), ncol = 3, byrow = TRUE)
plotPoints3D(pts)
plotHull3D(pts, argsPolygon3d = list(color = "red"))
convexHull(pts)
plotHull3D(pts, addRays = TRUE)
convexHull(pts, addRays = TRUE)
finalize3D()
}
