/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.PowerOptionsPanel;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.CVPanel;
import org.af.gMCP.gui.power.ScenarioPanelInterface;
import org.af.gMCP.gui.power.UserDefinedPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDialog
extends JDialog {
    CreateGraphGUI parent;
    Vector<Node> nodes;
    ScenarioPanelInterface pNCP;
    UserDefinedPanel userDefinedFunctions;
    CVPanel cvPanel;
    PowerOptionsPanel oPanel;
    File config;
    File path = null;
    boolean tmp = false;
    String rCommand = "";
    JTabbedPane tPanel = new JTabbedPane();
    GridBagConstraints c = PDialog.getDefaultGridBagConstraints();

    public PDialog(CreateGraphGUI parent, String string, boolean b) {
        super(parent, string, b);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        if (Configuration.getInstance().getGeneralConfig().usePersistentConfigFile()) {
            this.path = new File(Configuration.getInstance().getGeneralConfig().getConfigDir());
        } else {
            this.path = new File(RControl.getR().eval("tempdir()").asRChar().getData()[0]);
            this.tmp = true;
        }
        if (!this.path.exists()) {
            JOptionPane.showMessageDialog(this, "Directory for saving the settings does not exist:\n" + this.path.exists() + "\nPlease choose another directory in the options.\nFor now settings are only saved temporarily.", "Directory does not exist.", 0);
            this.path = new File(RControl.getR().eval("tempdir()").asRChar().getData()[0]);
            this.tmp = true;
        }
        parent.getPView().getParameters();
        this.getContentPane().setLayout(new GridBagLayout());
        this.nodes = parent.getGraphView().getNL().getNodes();
    }

    public Vector<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public CreateGraphGUI getParent() {
        return this.parent;
    }

    public void loadConfig(Element root) {
        this.pNCP.loadConfig((Element)root.getElementsByTagName("scenarios").item(0));
        if (!this.parent.getPView().jrbRCorrelation.isSelected()) {
            this.cvPanel.loadConfig((Element)root.getChildNodes().item(1));
        }
        if (this.userDefinedFunctions != null) {
            this.userDefinedFunctions.loadConfig((Element)root.getChildNodes().item(2));
        }
    }

    public List<Element> getConfigurationNodes(Document document) {
        Vector<Element> v = new Vector<Element>();
        v.add(this.pNCP.getConfigNode(document));
        v.add(this.cvPanel.getConfigNode(document));
        if (this.userDefinedFunctions != null) {
            v.add(this.userDefinedFunctions.getConfigNode(document));
        }
        return v;
    }

    public static GridBagConstraints getDefaultGridBagConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        return c;
    }
}

