/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.StrutBox;

public class HorizontalBox
extends Box {
    private float curPos = 0.0f;

    public HorizontalBox(Box b, float w, int alignment) {
        if (w != Float.POSITIVE_INFINITY) {
            float rest = w - b.getWidth();
            if (alignment == 2 || alignment == 5) {
                StrutBox s = new StrutBox(rest / 2.0f, 0.0f, 0.0f, 0.0f);
                this.add(s);
                this.add(b);
                this.add(s);
            } else if (alignment == 0) {
                this.add(b);
                this.add(new StrutBox(rest, 0.0f, 0.0f, 0.0f));
            } else if (alignment == 1) {
                this.add(new StrutBox(rest, 0.0f, 0.0f, 0.0f));
                this.add(b);
            } else {
                this.add(b);
            }
        } else {
            this.add(b);
        }
    }

    public HorizontalBox(Box b) {
        this.add(b);
    }

    public HorizontalBox() {
    }

    public HorizontalBox(Color fg, Color bg) {
        super(fg, bg);
    }

    public void draw(Graphics2D g2, float x, float y) {
        this.startDraw(g2, x, y);
        float xPos = x;
        for (Box box : this.children) {
            box.draw(g2, xPos, y + box.shift);
            xPos += box.getWidth();
        }
        this.endDraw(g2);
    }

    public final void add(Box b) {
        this.recalculate(b);
        super.add(b);
    }

    public final void add(int pos, Box b) {
        this.recalculate(b);
        super.add(pos, b);
    }

    private void recalculate(Box b) {
        this.curPos += b.getWidth();
        this.width = Math.max(this.width, this.curPos);
        this.height = Math.max(this.children.size() == 0 ? Float.NEGATIVE_INFINITY : this.height, b.height - b.shift);
        this.depth = Math.max(this.children.size() == 0 ? Float.NEGATIVE_INFINITY : this.depth, b.depth + b.shift);
    }

    public int getLastFontId() {
        int fontId = -1;
        ListIterator it = this.children.listIterator(this.children.size());
        while (fontId == -1 && it.hasPrevious()) {
            fontId = ((Box)it.previous()).getLastFontId();
        }
        return fontId;
    }
}

