/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import org.mutoss.config.Configuration;
import org.mutoss.gui.RControl;
import org.mutoss.gui.graph.AbstractGraphControl;
import org.mutoss.gui.graph.GraphMCP;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.PView;

public class CreateGraphGUI
extends JFrame
implements WindowListener {
    GraphMCP graph;
    JLabel statusbar = new JLabel();
    GraphView gv;
    AbstractGraphControl agc;
    PView pview;

    public CreateGraphGUI(String graph, boolean debug, double grid) {
        super("Creating and modifying graphs");
        RControl.getRControl(debug);
        Configuration.getInstance().getGeneralConfig().setGridSize((int)grid);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/mutoss/gui/graph/images/rjavaicon64.png")).getImage());
        this.agc = new AbstractGraphControl(graph, this);
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.addWindowListener(this);
        this.makeContent();
        this.graph = new GraphMCP(graph, this.gv.getVS());
        this.setVisible(true);
    }

    public static void startGUI(String graph, boolean debug, double grid) {
        new CreateGraphGUI(graph, debug, grid);
    }

    private void makeContent() {
        this.gv = new GraphView(this.agc);
        this.pview = new PView(this.agc);
        JSplitPane splitPane = new JSplitPane(1, this.gv, this.pview);
        this.getContentPane().add(splitPane);
    }

    public static void main(String[] args) {
        new CreateGraphGUI("graph", true, 10.0);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public PView getPView() {
        return this.pview;
    }
}

