% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g3Lollipop.options.R
\name{g3Lollipop.options}
\alias{g3Lollipop.options}
\title{G3Lollipop plot options}
\usage{
g3Lollipop.options(chart.width = 800, chart.type = "pie",
  chart.margin = list(left = 40, right = 20, top = 15, bottom = 25),
  chart.background = "transparent", transition.time = 600,
  y.axis.label = "mutations", axis.label.font = "normal 12px Arial",
  axis.label.color = "#4f4f4f", axis.label.alignment = "middle",
  axis.label.dy = "-2em", legend.margin = list(left = 10, right = 0,
  top = 5, bottom = 5), legend.interactive = TRUE, legend.title = NA,
  lollipop.track.height = 420,
  lollipop.track.background = "rgb(244,244,244)",
  lollipop.pop.min.size = 2, lollipop.pop.max.size = 12,
  lollipop.pop.info.limit = 8, lollipop.pop.info.color = "#EEE",
  lollipop.line.color = "rgb(42,42,42)", lollipop.line.width = 0.5,
  lollipop.circle.color = "wheat", lollipop.circle.width = 0.5,
  lollipop.label.ratio = 1.4, lollipop.label.min.font.size = 10,
  lollipop.color.scheme = "accent", title.text = "",
  title.font = "normal 16px Arial", title.color = "#424242",
  title.alignment = "middle", title.dy = "0.35em", anno.height = 30,
  anno.margin = list(top = 4, bottom = 0),
  anno.background = "transparent", anno.bar.fill = "#e5e3e1",
  anno.bar.margin = list(top = 2, bottom = 2),
  domain.color.scheme = "category10", domain.margin = list(top = 0,
  bottom = 0), domain.text.font = "normal 11px Arial",
  domain.text.color = "#f2f2f2", legend = TRUE, tooltip = TRUE,
  brush = TRUE, zoom = TRUE)
}
\arguments{
\item{chart.width}{chart width. Default 800.}

\item{chart.type}{\emph{pie} or \emph{circle}. Default \emph{pie}.}

\item{chart.margin}{specify chart margin in _list_ format.\cr
Default \code{list(left = 40, right = 20, top = 15, bottom = 25)}.}

\item{chart.background}{chart background. Default \emph{transparent}.}

\item{transition.time}{chart animation transition time in millisecond.  Default 600.}

\item{y.axis.label}{Y-axis label text. Default \emph{mutations}.}

\item{axis.label.font}{css font style shorthand
(\emph{font-style font-variant font-weight font-size/line-height font-family}).
Default \emph{"normal 12px Arial"}.}

\item{axis.label.color}{axis label text color. Default \emph{#4f4f4f}.}

\item{axis.label.alignment}{axis label text alignment (start/end/middle).  Default \emph{middle}.}

\item{axis.label.dy}{text adjustment of axis label text.  Default \emph{-2em}.}

\item{legend.margin}{legend margin in \emph{list}.  Default \code{list(left = 10, right = 0, top = 5, bottom = 5)}.}

\item{legend.interactive}{legend interactive mode.  Default \code{TRUE}.}

\item{legend.title}{legend title. If \code{NA}, use \emph{factor.col}.  Default is \code{NA}.}

\item{lollipop.track.height}{height of lollipop track. Default 420.}

\item{lollipop.track.background}{background of lollipop track.  Default \emph{rgb(244,244,244)}}

\item{lollipop.pop.min.size}{lollipop pop minimal size.  Default 2.}

\item{lollipop.pop.max.size}{lollipop pop maximal size. Default 12.}

\item{lollipop.pop.info.limit}{threshold of lollipop pop size to show count information in middle of pop.  Default 8.}

\item{lollipop.pop.info.color}{lollipop pop information text color. Default \emph{#EEE}.}

\item{lollipop.line.color}{lollipop line color. Default \emph{rgb(42,42,42)}.}

\item{lollipop.line.width}{lollipop line width. Default 0.5.}

\item{lollipop.circle.color}{lollipop circle border color. Default \emph{wheat}.}

\item{lollipop.circle.width}{lollipop circle border width. Default 0.5.}

\item{lollipop.label.ratio}{lollipop click-out label font size to circle size ratio.  Default 1.4.}

\item{lollipop.label.min.font.size}{lollipop click-out label minimal font size.  Default 10.}

\item{lollipop.color.scheme}{color scheme to fill lollipop pops.  Default \emph{accent}.}

\item{title.text}{title of chart. Default is empty.}

\item{title.font}{font of chart title. Default \emph{normal 16px Arial}.}

\item{title.color}{color of chart title. Default \emph{#424242}.}

\item{title.alignment}{text alignment of chart title (start/middle/end). Default \emph{middle}.}

\item{title.dy}{text adjustment of chart title.  Default \emph{0.35em}.}

\item{anno.height}{height of protein structure annotation track.  Default 30.}

\item{anno.margin}{margin of protein structure annotation track.  Default \code{list(top = 4, bottom = 0)}.}

\item{anno.background}{background of protein structure annotation track.  Default \emph{transparent}.}

\item{anno.bar.fill}{background of protein bar in protein structure annotation track.  Default \emph{#e5e3e1}.}

\item{anno.bar.margin}{margin of protein bar in protein structure annotation track.  Default \code{list(top = 2, bottom = 2)}.}

\item{domain.color.scheme}{color scheme of protein domains.  Default \emph{category10}.}

\item{domain.margin}{margin of protein domains.  Default \code{list(top = 0, bottom = 0)}.}

\item{domain.text.font}{domain label text font in shorthand format.  Default \emph{normal 11px Arial}.}

\item{domain.text.color}{domain label text color.  Default \emph{#f2f2f2}.}

\item{legend}{if show legend.  Default \code{TRUE}.}

\item{tooltip}{if show tooltip.  Default \code{TRUE}.}

\item{brush}{if show brush.  Default \code{TRUE}.}

\item{zoom}{if enable zoom feature.  Default \code{TRUE}.}
}
\value{
a list with g3Lollipop plot options
}
\description{
G3Lollipop plot options
}
