% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{plot_residuals}
\alias{plot_residuals}
\title{Plot the residuals}
\usage{
plot_residuals(train_output, col)
}
\arguments{
\item{train_output}{Training output, can be the output of WA-PLS, WA-PLS with
\code{fx} correction, TWA-PLS, or TWA-PLS with \code{fx} correction}

\item{col}{choose which column of the fitted value to plot, in other words,
how many number of components you want to use}
}
\value{
plotting status
}
\description{
Plot the residuals, the black line is 0 line, the red line is the locally
estimated scatterplot smoothing, which shows the degree of local
compression
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")
                                      
# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Get the frequency of each climate variable fx
fx_Tmin <- fxTWAPLS::fx(modern_pollen$Tmin, bin = 0.02)
fx_gdd <- fxTWAPLS::fx(modern_pollen$gdd, bin = 20)
fx_alpha <- fxTWAPLS::fx(modern_pollen$alpha, bin = 0.002)

# MTCO
## WAPLS
fit_Tmin <- fxTWAPLS::WAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
fit_f_Tmin <- fxTWAPLS::WAPLS.w(taxa, 
                                modern_pollen$Tmin, 
                                nPLS = 5, 
                                usefx = TRUE, 
                                fx = fx_Tmin)
## TWAPLS
fit_t_Tmin <- fxTWAPLS::TWAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
fit_tf_Tmin <- fxTWAPLS::TWAPLS.w(taxa, 
                                  modern_pollen$Tmin, 
                                  nPLS = 5, 
                                  usefx = TRUE, 
                                  fx = fx_Tmin)
fxTWAPLS::plot_residuals(fit_Tmin, 3)
fxTWAPLS::plot_residuals(fit_f_Tmin, 3)
fxTWAPLS::plot_residuals(fit_t_Tmin, 3)
fxTWAPLS::plot_residuals(fit_tf_Tmin, 3)
}

}
\seealso{
\code{\link{TWAPLS.w}} and \code{\link{WAPLS.w}}
}
