% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_parameters.R
\name{select_control}
\alias{select_control}
\title{Set Parameters for Selection Step of
Fuzzy Forests}
\usage{
select_control(drop_fraction = 0.25, number_selected = 5, mtry_factor = 1,
  min_ntree = 5000, ntree_factor = 10)
}
\arguments{
\item{drop_fraction}{A number between 0 and 1.  Percentage of features
dropped at each iteration.}

\item{number_selected}{A positive number. Number of features
that will be selected by fuzzyforests.}

\item{mtry_factor}{In the case of regression, \code{mtry} is set to
\code{ceiling}(\eqn{\sqrt(p)}*\code{mtry_factor}).
In the case of classification, \code{mtry} is set to
\code{ceiling}((p/3)*\code{mtry_factor}).  If either
of these numbers is greater than p, \code{mtry} is
set to p.}

\item{min_ntree}{Minimum number of trees grown in each random forest.}

\item{ntree_factor}{A number greater than 1.  \code{ntree} for each
random forest is \code{ntree_factor} times the number
of features.  For each random forest, \code{ntree}
is set to \code{max}(\code{min_ntree},
\code{ntree_factor}*\code{p}).}
}
\value{
An object of type selection_control.
}
\description{
Creates \code{selection_control} object for
controlling how feature selection
will be carried out after features from different
modules have been combined.
}
\note{
This work was partially funded by NSF IIS 1251151 and AMFAR 8721SC.
}
\examples{
drop_fraction <- .25
number_selected <- 10
mtry_factor <- 1
min_ntree <- 5000
ntree_factor <- 5
select_params <- select_control(drop_fraction=drop_fraction,
                                number_selected=number_selected,
                                mtry_factor=mtry_factor,
                                min_ntree=min_ntree,
                                ntree_factor=ntree_factor)
}
\references{
Daniel Conn, Tuck Ngun, Christina M. Ramirez (2015). Fuzzy Forests: a New
WGCNA Based Random Forest Algorithm for Correlated, High-Dimensional Data,
Journal of Statistical Software, Manuscript in progress.
}

