% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDHeatwaves.R
\name{IDHeatwavesAlternative}
\alias{IDHeatwavesAlternative}
\title{Identify heat waves in a time series}
\usage{
IDHeatwavesAlternative(threshold, datafr, numDays)
}
\arguments{
\item{threshold}{Numeric string with threshold temperature used in
the heat wave definition, in degrees Fahrenheit.}

\item{datafr}{A dataframe with daily temperature projections in the
the city being processed. This dataframe must have two columns:
(1) the first column must have the date of each observation, with
class "Date" and; (2) the second column must have temperatures
in degrees Fahrenheit. In the normal running of this package, this
dataframe will be generated by the closure created by
\code{\link{createCityProcessor}}.}

\item{numDays}{Integer greater than 0 giving the number of days to
use in the extreme event definition (e.g., \code{numDays = 2} would define a
heat wave as two or more days above the threshold temperature).}
}
\value{
Returns the dataframe entered as \code{datafr}, but with new
   columns providing heat wave identifiers. The returned dataframe will
   have new columns for whether a day was part of a heat wave (\code{hw},
   0 / 1), and if it was part of a heat wave, the number of the heat wave
   (\code{hw.number}).
}
\description{
This function identifies heat waves in a time series of temperature
data using a heat wave definition that a heat wave must be a certain
number of days above the greater of either a given threshold or
80 degrees Fahrenheit.
}
\note{
There are a few cases near the edges of data frames when this function
   would return that a day was not a heat wave when it was. First, if the
   first day of the dataset is a heat wave because preceeding days exceeded
   the threshold, but the second day in the dataframe is not above the
   threshold, this function would not capture that the first day was a
   heat wave. A similar caveat applies to the last day in the dataframe.
   In northern hemisphere studies, this should not be a concern, as it is
   unlikely that Jan. 1 or Dec. 31 would qualify as
   a heat wave. However, care should be taken
   when using this function either with Southern Hemisphere cities
   or when exploring exposures that, unlike heat waves, may occur very
   early or late in the calendar year.
}
\examples{
\donttest{
data(datafr)
hw_ids <- IDHeatwavesAlternative(threshold = 80, datafr = datafr,
                                 numDays = 3)
}

}

