% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processHeatwaves.R
\name{createCityProcessor}
\alias{createCityProcessor}
\title{Create closure to identify and aggregate heat waves}
\usage{
createCityProcessor(global)
}
\arguments{
\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}
}
\value{
This function creates a closure that takes inputs of \code{threshold},
   \code{ensembleSeries}, and \code{custom} and will
   find and characterize all heat waves in all cities for a given
   ensemble. See the help file for \code{\link{formHwFrame}} for more
   information on the format of the dataframe created by this closure.
}
\description{
This function creates a closure that returns a
   dataframe with the identified heat waves and heat wave characteristics for
   a given city for the specified projection period, as generated by the
   \code{\link{createHwDataframe}} function.
}
\note{
The closure encapsulates an incrementer varaible and advances it
   with every call. This variable is used to index into the \code{cities}
   vector from the \code{global} object passed into this function.
}

