% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleApplyFunctions.R
\name{number_of_heatwaves}
\alias{number_of_heatwaves}
\title{Calculate number of heat waves}
\usage{
number_of_heatwaves(hw_datafr)
}
\arguments{
\item{hw_datafr}{A dataframe of heat waves and their characteristics, as
created by \code{\link{gen_hw_set}}}
}
\value{
A numeric value with the number of heat waves in a dataframe of
   heat waves, as generated by \code{\link{gen_hw_set}}.
}
\description{
This function takes a dataframe of heat waves, as created by
\code{\link{gen_hw_set}}, and calculates the number of heat waves in
the dataframe.
}
\details{
To calculate the number of heat waves, this function determines the number
of rows in the dataframe, since \code{\link{gen_hw_set}} outputs a
dataframe with one and only one row per heat wave.
}
\note{
This function is an example of a function that can be created and
   used to explore heat waves using the \code{\link{apply_all_models}}
   function.
}
\examples{
data(hw_datafr)
number_of_heatwaves(hw_datafr)

}

