% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{gen_hw_set}
\alias{gen_hw_set}
\title{Create and write heat wave projections}
\usage{
gen_hw_set(out, dataFolder, dataDirectories = list(historical = c(1980, 2004),
  rcp85 = c(2006, 2099)), citycsv, coordinateFilenames, tasFilenames,
  timeFilenames, IDheatwavesFunction = "IDHeatwavesCPPwrapper",
  thresholdBoundaries = c(1990, 1999), projectionBoundaries = c(2070, 2079),
  referenceBoundaries = c(2070, 2079), models_to_run = "all",
  probThreshold = 0.98, numDays = 2, printWarning = TRUE,
  threshold_ensemble = "r1i1p1", lat_lon_colnames = c("lat", "lon"),
  input_metric = "kelvin")
}
\arguments{
\item{out}{Character string with pathway to directory to which
heat wave files will be written. This should be a pathname to a directory
on the user's local computer. If the directory already exists, it will
be overwritten by this function, so the user should either specify a
pathname for a directory that does not yet exist or be willing to
overwrite the existing directory. The parent directory of the specified
directory must exist.}

\item{dataFolder}{Character string with pathway to a directory with
climate projection data. This directory must have a specific structure--
see the \code{futureheatwaves} vignette for guidance on setting up this
directory.}

\item{dataDirectories}{A list object, with two elements, one for each of the
two subdirectories included in the main directory. Typically, these will
be separate directories of historical and projection experiments from
climate models. Each element of the list should be named with the name of
the subdirectory and should provide a numeric vector with the starting and
ending years of the data within each of the two subdirectories (e.g.,
\code{list("historical" = c(1990, 1999), "rcp85" = c(2060, 2079))}
for a \code{dataFolder} with historical experiment data for 1990 to 1999
and RCP8.5 projections for 2060 to 2079).}

\item{citycsv}{Character string giving the filepath to a
comma-separated (.csv) file with, for each study city, a unique city
identifier, latitude, and longitude. These values must be specified with
the column names \code{city}, \code{lat}, and \code{lon}. See the
\code{futureheatwaves} vignette for guidance on setting up this
file.}

\item{coordinateFilenames}{Character string the with filename of each
grid point location file. This filename should be identical for all
ensemble member subdirectories included in the \code{dataFolder} directory.
See the package vignette for an example of the required structure for this
file.}

\item{tasFilenames}{Character string the with filename of each climate
projection file. This filename should be identical for all ensemble
member subdirectories included in the \code{dataFolder} directory. See the
package vignette for an example of the required structure for this file.}

\item{timeFilenames}{Character string the with filename of each projection
dates file. This filename should be identical for all ensemble
member  subdirectories included in the \code{dataFolder} directory. See
the package vignette for an example of the required structure for this
file.}

\item{IDheatwavesFunction}{A character string with the name of the R function
to use to identify heat waves. This function may be a user-specified custom
function, but it must be loaded into the current R session. The
function name must be put in quotation marks. For more guidance on how to
write and use a custom function to identify heat waves, see the package
vignette for \code{futureheatwaves}.}

\item{thresholdBoundaries}{A numeric vector with the custom time boundaries
to be used to determine the threshold temperatures for the heat wave
definition. The required format for this vector is c(start year, end
year), with the restriction that bounds must be contained within the
time boundaries of one of the two experiment subdirectories specified
by the \code{dataDirectories} argument in \code{\link{gen_hw_set}}.
The default value is 1990 to 1999.}

\item{projectionBoundaries}{A numeric vector with the custom time boundaries
for which the user wants to create heat wave projections. The required
format for this vector is c(start year, end year), with the restriction
that bounds must be contained within the time boundaries of one of the two
experiment subdirectories specified by the \code{dataDirectories} argument
in \code{\link{gen_hw_set}}. The default value is 2070 to 2079.}

\item{referenceBoundaries}{A numeric vector with the custom time boundaries
to use in calculating relative characteristics for heat waves (i.e., to use
when exploring the role of adaptation in projections). For more
information on how reference temperatures are used, see the package
vignette for \code{futureheatwaves}. The required format for this vector
is c(start year, end year), with the restriction that bounds must be
contained within the time boundaries of one of the two experiment
subdirectories specified by the \code{dataDirectories} argument in
\code{\link{gen_hw_set}}. The default value is 2070 to 2079. If the
time bounds used differ from those used for projections, these reference
temperatures will be pulled from the ensemble member for each climate
model specified by \code{threshold_ensemble}.}

\item{models_to_run}{A character vector with either "all" (the default),
in which case the function runs through all models in the \code{dataFolder}
directory, or the names of the models to run, using the names of each
model's subdirectory within the data directory (e.g.,
\code{c("bcc1", "ccsm")}).}

\item{probThreshold}{Numerical value between 0 and 1 specifying the
percentile to be used for the threshold temperature used to define heat
waves. The default value is 0.98 (i.e., a heat wave is a certain number of
days above the city's 98th percentile temperature).}

\item{numDays}{Integer greater than 0 giving the number of days to
use in the heat wave definition (e.g., \code{numDays = 2} would define a
heat wave as two or more days above the threshold temperature).}

\item{printWarning}{TRUE / FALSE, specifies whether to print out a warning
informing the user that the function will write out results to the local
directory specified by the user with \code{out}. This warning prints out
by default; the user must opt out of this warning by specifying FALSE
for this argument, for example if running this function within a loop.}

\item{threshold_ensemble}{A character vector giving the name of the ensemble
member that should be used when determining the city-specific threshold
temperatures  for each climate model (e.g., \code{"r1i1p1"}). This
threshold is used for relative heat wave definitions. See the
\code{futureheatwaves} vignette for more on heat wave definitions.
If any climate model lacks that ensemble member for the specified
dates for calculating the threshold, it will be excluded from the
processing.}

\item{lat_lon_colnames}{A character vector of length two with the column names
in the \code{citycsv} dataframe for latitude (first vector element) and
longitude (second vector element)}

\item{input_metric}{A character string indicating the temperature metric
of the climate projection data being processed. Choices are "kelvin",
"fahrenheit", and "celsius".}
}
\value{
This function creates, and writes to the user's computer, files with
   the heat waves and their characteristics for the specified climate
   projections and dates. For more information on customizing this function,
   see the \code{futureheatwaves} vignette. This function also returns a
   dataframe listing the name of each climate model processed, as well as the
   number of historical and future projection ensemble members for each
   model. This output can be used as a check that the function processed
   through the directory of input files specified using the \code{dataFolder}
   argument.
}
\description{
This function creates datasets of identified and characterized heat waves
for all ensemble members in all climate models in a directory of climate
projections for a user-specified set of locations.The resulting heat wave
projections are written out to a specified directory on the user's local
computer.
}
\examples{
\dontrun{
projection_dir_location <- system.file("extdata/cmip5",
                                      package = "futureheatwaves")
city_file_location <- system.file("extdata/cities.csv",
                                 package = "futureheatwaves")
gen_hw_set(out = "example_results",
           dataFolder = projection_dir_location ,
           dataDirectories = list("historical" = c(1990, 1999),
                                  "rcp85" = c(2060, 2079)),
           citycsv = city_file_location,
           coordinateFilenames = "latitude_longitude_NorthAmerica_12mo.csv",
           tasFilenames = "tas_NorthAmerica_12mo.csv",
           timeFilenames = "time_NorthAmerica_12mo.csv")
}

}

