% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\title{Create a cluster future whose value will be resolved asynchronously in a parallel process}
\usage{
cluster(..., workers = availableWorkers(), envir = parent.frame())
}
\arguments{
\item{\dots}{Additional named elements passed to \code{\link[=ClusterFuture]{ClusterFuture()}}.}

\item{workers}{A \code{\link[parallel:makeCluster]{cluster}} object,
a character vector of host names, a positive numeric scalar,
or a function.
If a character vector or a numeric scalar, a \code{cluster} object
is created using \code{\link{makeClusterPSOCK}(workers)}.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return any of the above types.}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{ClusterFuture}.
}
\description{
A cluster future is a future that uses cluster evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function will block if all available \R cluster nodes are
occupied and will be unblocked as soon as one of the already
running cluster futures is resolved.

The preferred way to create an cluster future is not to call
this function directly, but to register it via
\code{\link{plan}(cluster)} such that it becomes the default
mechanism for all futures.  After this \code{\link[=future]{future()}}
and \code{\link{\%<-\%}} will create \emph{cluster futures}.
}
\examples{
\donttest{

## Use cluster futures
cl <- parallel::makeCluster(2L, timeout = 60)
plan(cluster, workers = cl)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A cluster future is evaluated in a separate process.
## Regardless, changing the value of a global variable will
## not affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## CLEANUP
parallel::stopCluster(cl)

}
}
