% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\title{Create a cluster future whose value will be resolved asynchroneously in a parallel process}
\usage{
cluster(expr, envir = parent.frame(), substitute = TRUE,
  persistent = FALSE, workers = NULL, gc = FALSE, earlySignal = FALSE,
  ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done and from which globals are obtained.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{workers}{A cluster object created by
\code{\link[parallel]{makeCluster}()}.}

\item{gc}{If TRUE, the garbage collector run after the future
is resolved (in the process that evaluated the future).}

\item{earlySignal}{Specified whether conditions should be signaled as soon as possible or not.}

\item{\dots}{Not used.}
}
\value{
A \link{ClusterFuture}.
}
\description{
A cluster future is a future that uses cluster evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function will block if all available R cluster nodes are
occupied and will be unblocked as soon as one of the already
running cluster futures is resolved.

The preferred way to create an cluster future is not to call
this function directly, but to register it via
\code{\link{plan}(cluster)} such that it becomes the default
mechanism for all futures.  After this \code{\link{future}()}
and \code{\link{\%<=\%}} will create \emph{cluster futures}.
}
\examples{
## Cluster futures gives an error on R CMD check on
## Windows (but not Linux or OS X) for unknown reasons.
## The same code works in package tests.
\donttest{

## Use cluster futures
cl <- parallel::makeCluster(2L)
plan(cluster, workers=cl)

## A global variable
a <- 0

## Create multicore future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A cluster future is evaluated in a separate process.
## Changing the value of a global variable will not
## affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## CLEANUP
parallel::stopCluster(cl)

}
}

