# WARNING - Generated by {fusen} from dev/flat_addins.Rmd: do not edit by hand # nolint: line_length_linter.

# No tests for addins

test_that("build_fusen_chunks works properly", {
  res <- build_fusen_chunks("pouet")
  expect_true(
    grepl("^# pouet", res)
  )

  expect_true(
    grepl("development-pouet", res)
  )

  expect_true(
    grepl("function-pouet", res)
  )
  expect_true(
    grepl("example-pouet", res)
  )
  expect_true(
    grepl("function-pouet", res)
  )
  expect_true(
    grepl("tests-pouet", res)
  )
  expect_true(
    grepl("Title", res)
  )
  expect_true(
    grepl("Description", res)
  )
  expect_true(
    grepl("@return", res)
  )
  expect_true(
    grepl("@export", res)
  )
  res <- build_fusen_chunks("pouet", FALSE)
  expect_true(
    grepl("@noRd", res)
  )
})

# function names are clean ----
test_that("build_fusen_chunks cleans functions names", {
  expect_message(
    res <- build_fusen_chunks("1po @uet ()"),
    regexp = "Your function name was cleaned:"
  )
  expect_true(
    grepl("^# po_uet", res)
  )

  expect_true(
    grepl("development-po_uet}", res)
  )

  expect_true(
    grepl("function-po_uet}", res)
  )
  expect_true(
    grepl("example-po_uet}", res)
  )
  expect_true(
    grepl("tests-po_uet}", res)
  )
  expect_true(
    grepl("Title", res)
  )
  expect_true(
    grepl("Description", res)
  )
  expect_true(
    grepl("@return", res)
  )
  expect_true(
    grepl("@export", res)
  )
  expect_message(
    res <- build_fusen_chunks("1po @uet ()", FALSE),
    regexp = "Your function name was cleaned:"
  )
  expect_true(
    grepl("@noRd", res)
  )
})

# Create a new package, add set of chunks with export and check ----
dummydir <- tempfile(pattern = "chunk.export.")
dir.create(dummydir)
path_foosen <- file.path(dummydir, "foosen")

test_that("build_fusen_chunks add lines with export as expected", {
  withr::with_dir(dummydir, {
    dev_file <- create_fusen(path_foosen, template = "minimal", open = FALSE)
    fill_description(pkg = path_foosen, fields = list(Title = "Dummy Package"))
    path_dev_history <- dev_file[grepl("flat", dev_file)]
    dev_lines_orig <- readLines(path_dev_history)

    # If interactive in RStudio
    if (
      requireNamespace("rstudioapi") &&
        rstudioapi::isAvailable() &&
        rstudioapi::hasFun("navigateToFile") &&
        rstudioapi::hasFun("documentSave")
    ) {
      print("Test with RStudio")
      # current position
      curr_editor <- rstudioapi::getSourceEditorContext()
      curr_position <- curr_editor$selection[[1L]]$range$start
      # Change file
      rstudioapi::navigateToFile(path_dev_history, line = 44)
      Sys.sleep(1)
      open_editor <- rstudioapi::getSourceEditorContext()
      id <- open_editor$id
      # add chunks
      add_fusen_chunks(function_name = "zaza", export = TRUE)
      rstudioapi::documentSave(id)
      if (rstudioapi::hasFun("documentClose")) {
        rstudioapi::documentClose(id)
      }
      # # Back to current position
      rstudioapi::navigateToFile(curr_editor$path, line = curr_position[1])
    } else {
      print("test without interactive")
      dev_lines <- readLines(path_dev_history)
      dev_lines[44] <- build_fusen_chunks("zaza", export = TRUE)
      cat(dev_lines, sep = "\n", file = path_dev_history)
    }
    dev_lines_new <- readLines(path_dev_history)
    expect_equal(length(dev_lines_new), length(dev_lines_orig) + 28)
    expect_equal(dev_lines_new[44], "# zaza")
    expect_equal(dev_lines_new[46], "```{r development-zaza}")
    expect_equal(dev_lines_new[50], "```{r function-zaza}")
    expect_equal(dev_lines_new[57], "#' @export")
    expect_equal(dev_lines_new[63], "```{r example-zaza}")
    expect_equal(dev_lines_new[64], "zaza()")
    expect_equal(dev_lines_new[67], "```{r tests-zaza}")

    unlink(path_foosen, recursive = TRUE)
  })
})

# Create a new package, add set of chunks with noRd and check ----
dummydir <- tempfile(pattern = "chunk.noRd.")
dir.create(dummydir)
path_foosen <- file.path(dummydir, "foosen")

test_that("build_fusen_chunks add lines with noRd as expected", {
  withr::with_dir(dummydir, {
    dev_file <- create_fusen(path_foosen, template = "minimal", open = FALSE)
    fill_description(pkg = path_foosen, fields = list(Title = "Dummy Package"))
    path_dev_history <- dev_file[grepl("flat", dev_file)]
    dev_lines_orig <- readLines(path_dev_history)

    # If interactive in RStudio
    if (
      requireNamespace("rstudioapi") &&
        rstudioapi::isAvailable() &&
        rstudioapi::hasFun("navigateToFile") &&
        rstudioapi::hasFun("documentSave")
    ) {
      print("Test with RStudio")
      # current position
      curr_editor <- rstudioapi::getSourceEditorContext()
      curr_position <- curr_editor$selection[[1L]]$range$start
      # Change file
      rstudioapi::navigateToFile(path_dev_history, line = 44)
      Sys.sleep(1)
      open_editor <- rstudioapi::getSourceEditorContext()
      id <- open_editor$id
      # add chunks
      add_fusen_chunks(function_name = "zaza", export = FALSE)
      rstudioapi::documentSave(id)
      if (rstudioapi::hasFun("documentClose")) {
        rstudioapi::documentClose(id)
      }
      # # Back to current position
      rstudioapi::navigateToFile(curr_editor$path, line = curr_position[1])
    } else {
      print("test without interactive")
      dev_lines <- readLines(path_dev_history)
      dev_lines[44] <- build_fusen_chunks("zaza", export = FALSE)
      cat(dev_lines, sep = "\n", file = path_dev_history)
    }
    dev_lines_new <- readLines(path_dev_history)
    expect_equal(length(dev_lines_new), length(dev_lines_orig) + 28)
    expect_equal(dev_lines_new[44], "# zaza")
    expect_equal(dev_lines_new[46], "```{r development-zaza}")
    expect_equal(dev_lines_new[50], "```{r function-zaza}")
    expect_equal(dev_lines_new[57], "#' @noRd")
    expect_equal(dev_lines_new[63], "```{r example-zaza}")
    expect_equal(dev_lines_new[64], "zaza()")
    expect_equal(dev_lines_new[67], "```{r tests-zaza}")
    unlink(path_foosen, recursive = TRUE)
  })
})
