% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funspaceNull.R
\name{funspaceNull}
\alias{funspaceNull}
\title{Null models in functional space}
\usage{
funspaceNull(
  funspace,
  nrep = 100,
  alter = "greater",
  null.distribution = "multnorm",
  verbose = TRUE
)
}
\arguments{
\item{funspace}{An object of class \code{funspace}}

\item{nrep}{\code{numeric}The number of generated null surfaces}

\item{alter}{\code{character}. The hypothesis to be tested when comparing the observed trait space against the null model. Options are 'greater', 'less', and 'two-sided'. See specification of the \code{as.randtest} function in the \code{ade4} R package}

\item{null.distribution}{\code{character}. Data distribution for null model building. Available options are 'multnorm' and 'uniform' to generate data with a multivariate normal or uniform distribution, respectively.}

\item{verbose}{\code{logical}. Do you want to  information about the progress of the null model to be written to the console?}
}
\value{
\code{funspaceNull} The function returns the list containing all the simulated datasets, the area of the observed trait space, the mean value of the area for the null model (calculated across iterations), the p-value of the difference between observed and simulated trait space, as well as a standardized effect size of the difference between observed trait space and mean null model areas. This output is reported together with the output of  \code{funspace}.
}
\description{
Comparing the amount of occupied functional space against null models
}
\details{
\code{funspaceNull} The function tests for the statistical difference between the size (functional richness) of the considered TPD, obtained using the \code{funspace} function, against a vector of functional richness values generated using null models (see below) across a user-defined number of iterations. Two null models are currently available for testing. One generates data with a multivariate normal distribution, creating a dataset with normally distributed variables having the same mean and covariance than the observations used to build the functional space (see Carmona et al. 2021). This null model returns a theoretical TPD where some trait combinations (those around the mean of the trait space axes, thus towards the center of the null trait space) are more likely than others (i.e., this null model resembles an ellipse). The other null model generates a dataset with variables following a uniform distribution (see null model 1 in Diaz et al. 2016), creating a distribution where all trait combinations within the range of the original observations are equally possible (i.e., the approximate shape of this null model is a rectangle).
}
\examples{

# 1. PCA space, multivariate model (see Carmona et al. 2021, Nature)
x <- princomp(GSPFF)
funtest <- funspace(x = x, PCs = c(1, 2), threshold = 0.95)
\donttest{funtestNull <- funspaceNull(funtest, null.distribution = 'multnorm', nrep = 1000)}
\donttest{summary(funtestNull)}

#'# 2. Two raw traits and uniform distribution (see Diaz et al. 2016, Nature)
x <- GSPFF[, c("ph", "sla")]
funtest <- funspace(x = x, threshold = 0.95)
\donttest{funtestNull <- funspaceNull(funtest, null.distribution = 'uniform', nrep = 1000)}
\donttest{summary(funtestNull)}

}
\references{
CP Carmona, et al. (2021). Fine-root traits in the global spectrum of plant form and function. Nature 597, 683–687
S Diaz, et al. (2016). The global spectrum of plant form and function. Nature 529, 167–171
}
