% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/on.R
\name{\%on\%}
\alias{\%on\%}
\alias{on}
\title{Transform a binary function with a unary function}
\usage{
f \%on\% g
}
\arguments{
\item{f}{a binary function.}

\item{g}{a unary function.}
}
\value{
A binary function. This function transforms 2 inputs (with g) and
combines the outputs (with f).
}
\description{
Execute the binary function f on the results of applying unary function g to
two arguments x and y.
}
\details{
Formally, \code{\%on\%} is defined this way :
\code{function(f, g) function(x, y) f(g(x), g(y))}.

f can be a function taking two arguments but also a variadic function (i.e.
whose first argument is \code{...}), which will be fed with exactly two
arguments.

A typical usage of this function is in combination with function like
\code{\link{group_if}}.
}
\examples{
h <- max \%on\% abs
h(-2, 1)
}
