% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_01_pca.mfd.R
\name{pca_mfd_real_time}
\alias{pca_mfd_real_time}
\title{Get a list of multivariate functional principal component analysis
models estimated on functional data
each evolving up to an intermediate domain point.}
\usage{
pca_mfd_real_time(mfdobj_list, scale = TRUE, nharm = 20, ncores = 1)
}
\arguments{
\item{mfdobj_list}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects,
each evolving up to an intermediate domain point,
with observations of the multivariate functional data.}

\item{scale}{See \code{\link{pca_mfd}}.}

\item{nharm}{See \code{\link{pca_mfd}}.}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating objects separately for different instants.}
}
\value{
A list of lists each produced by \code{\link{pca_mfd}},
corresponding to a given instant.
}
\description{
This function produces a list of objects,
each of them contains the result of applying \code{\link{pca_mfd}} to
a multivariate functional data object
evolved up to an intermediate domain point.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[1:10, , drop = FALSE])
mfdobj_list <- get_mfd_list_real_time(air[c("CO", "temperature")],
                                      n_basis = 15,
                                      lambda = 1e-2,
                                      k_seq = seq(0.25, 1, length = 5))
mod_list <- pca_mfd_real_time(mfdobj_list)

}
\seealso{
\code{\link{pca_mfd}}
}
\author{
C. Capezza
}
