% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_abstract.R
\name{ft_abstract}
\alias{ft_abstract}
\alias{ft_abstract_ls}
\title{Get abstracts}
\usage{
ft_abstract(x, from = "plos", plosopts = list(), scopusopts = list(),
  maopts = list(), crossrefopts = list(), ...)

ft_abstract_ls()
}
\arguments{
\item{x}{(character) DOIs as a character vector}

\item{from}{Source to query. One or more of plos (default),
scopus, microsoft, or crossref}

\item{plosopts}{PLOS options}

\item{scopusopts}{Scopus options}

\item{maopts}{Microsoft Academic options}

\item{crossrefopts}{Crossref options}

\item{...}{curl options passed on to \code{\link[httr:GET]{httr::GET()}} or \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
An object of class \code{ft_abstract}
}
\description{
Get abstracts
}
\details{
See \strong{Rate Limits} and \strong{Authentication} in
\link{fulltext-package} for rate limiting and authentication information,
respectively
}
\examples{
# List publishers included
ft_abstract_ls()

\dontrun{
# PLOS
## search
(res <- ft_search(query = 'biology', from = 'plos', limit = 25, 
   plosopts = list(fq = list('doc_type:full', '-article_type:correction',
                  '-article_type:viewpoints'))))
## get abstracts
dois <- res$plos$data$id
(out <- ft_abstract(x = dois, from = "plos"))
out$plos

# Scopus
opts <- list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY'))

## search
(res <- ft_search(query = 'biology', from = 'scopus', scopusopts = opts, 
  limit = 25))
## get abstract
dois <- na.omit(res$scopus$data$`prism:doi`)
out <- ft_abstract(x = dois[1], from = "scopus", scopusopts = opts)
out
out$scopus

(out <- ft_abstract(x = dois[1:5], from = "scopus", scopusopts = opts))

# use scopus Ids
(res <- ft_search(query = 'biology', from = 'scopus', scopusopts = opts, 
  limit = 50))
ids <- fulltext:::strextract(res$scopus$data$`dc:identifier`, "[0-9]+")
(out <- ft_abstract(x = ids[1:4], from = 'scopus', 
  scopusopts = list(
    key = Sys.getenv('ELSEVIER_SCOPUS_KEY'),
    id_type = "scopus_id"
  )
))

# Microsoft
key <- Sys.getenv("MICROSOFT_ACADEMIC_KEY")
(res <- ft_search("Y=[2010, 2012)", from = "microsoft", 
  maopts = list(key = key)))
ids <- res$ma$data$Id
(out <- ft_abstract(x = ids, from = "microsoft",
  maopts = list(
    key = Sys.getenv('MICROSOFT_ACADEMIC_KEY')
  )
))
out$ma
cat(unlist(lapply(out$ma, "[[", "abstract")), sep = "\\n\\n")

# Crossref
(res <- ft_search("ecology", from = "crossref", 
  crossrefopts = list(filter = c(has_abstract = TRUE))))
ids <- res$crossref$data$doi
(out <- ft_abstract(x = ids, from = "crossref"))
out$crossref
}
}
